# Prompt Infection: LLM-to-LLM Prompt Injection within Multi-Agent Systems

We would like to thank the reviewers for taking the time to review our submission and provide valuable feedback. This repository contains the code and resources for the experiments on **Prompt Infection**.

## Setup

### Requirements

To install the required Python dependencies, run:

```bash
pip install -r requirements.txt
```

### Setting Up Your API Key

You need to set your `OPENAI_API_KEY` to use the OpenAI models. You can do this by setting the environment variable:

```bash
export OPENAI_API_KEY="your_openai_api_key"
```

On Windows, use:

```bash
set OPENAI_API_KEY="your_openai_api_key"
```

Make sure to replace `"your_openai_api_key"` with your actual OpenAI API key.

## Running the Experiments

### Running the Threat Experiments

To run the experiments, execute the following command:

```bash
python experiments/run_experiments.py
```

### Plotting the Results

To generate plots from the experiment results, run:

```bash
python experiments/plot.py
```
