from langchain.tools import BaseTool
import pandas as pd
import os


class CSVTool(BaseTool):
    name: str = "csv_reader"
    description: str = "Read a CSV file and return its contents."

    def __init__(self):
        super().__init__()

    def read_csv(self) -> str:
        current_dir = os.path.dirname(os.path.realpath(__file__))
        csv_path = os.path.join(current_dir, "customer_data.csv")
        csv = pd.read_csv(csv_path, index_col=False)
        return csv

    def _run(self) -> str:
        """
        Return the contents of a CSV file.
        """
        try:
            csv = self.read_csv()
            print("CSV returned")
            return f"Here are the CSV contents returned:\n\n{csv}"
        except Exception as e:
            print(f"Error reading the CSV file: {str(e)}")
            return f"Error reading the CSV file: {str(e)}"

    def _arun(self):
        raise NotImplementedError("CSVTool does not support async")
