import pyfiglet
from termcolor import colored
from colorama import Fore, Style


def colored_print(text, color: str = "white"):
    fore_color = None
    if color == "G":
        fore_color = Fore.GREEN
    elif color == "R":
        fore_color = Fore.RED
    elif color == "B":
        fore_color = Fore.BLUE
    elif color == "Y":
        fore_color = Fore.YELLOW
    elif color == "GRAY":
        fore_color = Fore.LIGHTBLACK_EX

    print(f"{fore_color} {text} {Style.RESET_ALL}")


def pretty_print(text, color="white", font="standard", size="medium"):
    # Define padding and font based on size
    if size == "tiny":
        font = font or "mini"
        padding = 0
    elif size == "small":
        font = font or "small"
        padding = 0
    elif size == "normal":
        font = font or "standard"
        padding = 1
    elif size == "big":
        font = font or "big"
        padding = 2
    else:
        font = font or "standard"
        padding = 1

    # Generate the figlet text
    result = pyfiglet.figlet_format(text, font=font)

    # Add padding
    padded_result = "\n".join(
        " " * padding + line for line in result.split("\n")
    )

    # Color the result
    colored_result = colored(padded_result, color)

    print(colored_result)
