import numpy as np


def test_rel_stoch_order_test():
    from soe.testing import StochasticOrderTesting

    k = 15  # number of models
    n_samples = 100  # number of scores per model

    # Generate random scores with a given random mean
    means = np.random.permutation(k)
    gt_rank = np.argsort(means)[::-1]

    # For every model we have its scores in a list
    scores_list = [m + np.random.randn(n_samples) for m in means]

    # Compute relative test
    tst = StochasticOrderTesting(scores_list, n_bootstrap=100)

    alpha = 0.5 * k**2  # Make sure that the test is passed
    rank_rel_qs, rank_rel_iqs = tst.compute_relative_test(alpha=alpha)

    # Check rank obtained with quantiles
    assert all(rank_rel_qs == gt_rank)

    # Check rank obtained with integrated quantiles
    assert all(rank_rel_iqs == gt_rank)

    # Compute absolute test (usig caches comptation)
    alpha = 0.5 * k**2  # Make sure that the test is passed
    rank_abs_qs, rank_abs_iqs = tst.compute_absolute_test(alpha=alpha, tau=0.25)

    # Check rank obtained with quantiles
    assert all(rank_abs_qs == gt_rank)

    # Check rank obtained with integrated quantiles
    assert all(rank_abs_iqs == gt_rank)
