class SearchAPI:
    def __init__(self):
        """
        Initializes the base search API, which is used by subclasses to implement specific search behaviors.
        """
        pass

    def compute_query(self, query):
        """
        Placeholder for computing the query. Subclasses must implement this to handle the query (text or image).

        Args:
            query (str or base64): Text query or base64-encoded image.

        Returns:
            Processed query (str or torch.Tensor)
        """
        raise NotImplementedError("Subclasses must implement the compute_query method.")

    def retrieve_query(self, query):
        """
        Placeholder for retrieving results based on the computed query. Subclasses must implement this.

        Args:
            query (str or torch.Tensor): Processed query (text or embedding).

        Returns:
            List of search results.
        """
        raise NotImplementedError(
            "Subclasses must implement the retrieve_query method."
        )

    def search(self, query, top_k=5):
        """
        Perform a search based on the given query (text or image).

        Args:
            query (str or base64): Text query or base64-encoded image.

        Returns:
            List of search results.
        """
        # Step 1: Compute the query (either text or image embedding)
        computed_query = self.compute_query(query)

        # Step 2: Retrieve search results
        return self.retrieve_query(computed_query)
