#!/bin/bash

# /home/footoredo/miniconda3/bin/conda activate py3.7

# while [ ! -z $CONDA_PREFIX ]; do conda deactivate; done

kill -9 $(pgrep -f "torchbeast.polyhydra")

# python_exe=${ISAACSIM_PATH}/python.sh
python_exe="python"
root=`cat torchbeast/LOGDIR`
env=$1
task=$2
name=$3
env_names=(${env//\// })
base_env=${env_names[0]}
if [ -z ${env_names[1]} ]
then
    group=$task
else
    group=${env_names[1]}-${task}
fi
savedir=$root/$env/$task/$name
shift 3
if [ -d "$savedir" ]; then
    read -p "$savedir exists, resume? (y/n) " -n 1 -r
    if [[ $REPLY =~ ^[Yy]$ ]]
    then
        echo "Resume training..."
    elif [[ $REPLY =~ ^[Nn]$ ]]
    then
        rm -rf $savedir
    else
        exit 0
    fi
fi

$python_exe -m torchbeast.polyhydra env_config=${base_env} task=${task} \
    data_root=$root \
    env=${env//\//-} \
    project=${base_env}-impala \
    group=${group} \
    wandb_name=${name} \
    savedir=$savedir \
    $@ # > torchbeast/output.log
