from config.default_config import config, SimpleNamespace

config.model.hparams = "./hparams/2023_06_20-08_43_22-6M-CategoryEmbedding.pickle"

config.model.gpus = [1]
config.model.max_epochs = 1000
config.model.batch_size = 2048
config.model.early_stopping_patience = 50
config.model.auto_select_gpus = False
config.model.use_balanced_sampler = True

config.model.use_weighted_loss = True

config.model.mu = 0.1

config.model.path = None

config.optuna.hparams = {
    'embedding_dropout' : ['suggest_uniform', ['embedding_dropout', 0.0, 0.2]],
    'layers' : ['suggest_categorical', ['layers', ['128-64-32', '256-128-64', '128-64-32-16', '256-128-64-32']]],
    'activation' : ['suggest_categorical', ['activation', ['ReLU', 'LeakyReLU']]],
    # 'use_batch_norm' : ['suggest_categorical', ['use_batch_norm', [True, False]]],
    'learning_rate' : ['suggest_uniform', ['learning_rate',0.0001, 0.05]],   
    'scheduler_gamma' : ['suggest_uniform', ['scheduler_gamma', 0.1, 0.95]],
    'scheduler_step_size' : ['suggest_int', ['scheduler_step_size', 10, 100]],
}
