from config.default_config import config, SimpleNamespace

config.model.hparams = None

config.model.device = 'cuda:1'
config.model.verbose = 0
config.model.max_epochs = 1000
config.model.batch_size = 2048

config.model.early_stopping_patience = 50
config.model.pretrain_early_stopping_patience = 10

config.model.hparams = None

config.model.path = None

config.model.fast_dev_run = False

config.optuna.hparams = {
    'n_d' : ['suggest_int', ['n_d', 8, 32]],
    'n_steps' : ['suggest_int', ['n_steps', 3, 10]],
    'gamma' : ['suggest_uniform', ['gamma', 1.0, 2.0]],
    'cat_emb_dim' : ['suggest_categorical', ['cat_emb_dim', [1,2,4,8]]],
    'n_independent' : ['suggest_int', ['n_independent', 1, 5]],
    'n_shared' : ['suggest_int', ['n_shared', 1, 5]],
    'lambda_sparse' : ['suggest_uniform', ['lambda_sparse', 3e-5, 3e-3]],
    'mask_type' : ['suggest_categorical', ['mask_type', ['entmax', 'sparsemax']]],
    'scheduler_fn' : ['suggest_categorical', ['scheduler_fn', ['StepLR', None, 'CosineAnnealingLR']]],

    'lr' : ['suggest_uniform', ['lr',0.0001, 0.05]],
    
    'pretraining_ratio' : ['suggest_uniform', ['pretraining_ratio', 1e-5, 1]],


}
