from config.default_config import config, SimpleNamespace

config.model.hparams = "./hparams/2023_06_23-09_35_11-6M-FTTransformer.pickle"

config.model.gpus = [1]
config.model.max_epochs = 1000
config.model.batch_size = 256
config.model.early_stopping_patience = 50
config.model.auto_select_gpus = False
config.model.use_balanced_sampler = True

config.model.use_weighted_loss = True

config.model.mu = 0.1

config.model.path = None

config.optuna.hparams = {
    'input_embed_dim' : ['suggest_categorical', ['input_embed_dim', [16,24,32,48]]],
    'embedding_dropout' : ['suggest_uniform', ['embedding_dropout', 0.05, 0.3]],
    'share_embedding' : ['suggest_categorical', ['share_embedding', [True, False]]],
    'num_heads' : ['suggest_categorical', ['num_heads', [1, 2, 4, 8]]],
    'num_attn_blocks' : ['suggest_int', ['num_attn_blocks', 2, 10]],
    'transformer_activation' : ['suggest_categorical', ['transformer_activation', ['GEGLU', 'ReGLU', 'SwiGLU']]],
    'batch_norm_continuous_input' : ['suggest_categorical', ['batch_norm_continuous_input', [True, False]]],
    'learning_rate' : ['suggest_uniform', ['learning_rate',0.0001, 0.05]],
    'scheduler_gamma' : ['suggest_uniform', ['scheduler_gamma', 0.1, 0.95]],
    'scheduler_step_size' : ['suggest_int', ['scheduler_step_size', 10, 100]],
}
