from .data_module import DataModule
from sklearn.datasets import fetch_openml
from sklearn.preprocessing import LabelEncoder
import os
import pickle
from types import SimpleNamespace
from typing import Tuple, List
import pandas as pd

class Kc1DataModule(DataModule):
    def __init__(self, 
        config: SimpleNamespace
        ) -> None:
        super().__init__(config)
    
    def load_data(self) -> Tuple[pd.DataFrame, pd.Series]:
        kc1 = fetch_openml(data_id = self.config.data.data_id, data_home='./data_cache')

        data = kc1.data

        label = kc1.target
        
        label = pd.Series(LabelEncoder().fit_transform(label), index=data.index)

        return data, label
    
    def prepare_data(self) -> Tuple[pd.DataFrame, pd.Series, List[str], List[str]]:
        if os.path.exists(self.config.data.dataset_path):
            with open(self.config.data.dataset_path, 'rb') as f:
                dataset = pickle.load(f)    
            return dataset['data'], dataset['label'], dataset['numeric_cols'], dataset['category_cols']

        data, label = self.load_data()

        numeric_cols = list(map(str, data.columns))
        category_cols = []

        if self.config.runner_option.save_data:
            self.save_data(data, label, numeric_cols, category_cols)
            
        return data, label, numeric_cols, category_cols
    
