from sklearn.metrics import log_loss
import numpy as np
import pandas as pd
from sklearn.preprocessing import OneHotEncoder
from abc import ABC
from sklearn.metrics import accuracy_score

class CustomMetric(ABC, object):
    def __init__(self, labels):
        pass

class ProbabilisticAccuracy(CustomMetric):
    def __init__(self, labels):
        self.ohe = OneHotEncoder().fit(labels.values.reshape((-1, 1)))
    
    def __call__(self, 
                y_true : pd.Series, 
                y_pred : np.array,
        ) -> float:
        y_true = self.ohe.transform(y_true.values.reshape((-1, 1))).toarray()
        y_pred = self.ohe.transform(y_pred.reshape((-1, 1))).toarray()
        return np.exp(-log_loss(y_true, y_pred))
