#! /bin/bash

Installation
------------

Tested with Pyorch==1.8.1, torchvision==0.9.1

Install python-igraph by:
    pip install python-igraph

Install pygraphviz by:
    conda install graphviz
    conda install pygraphviz

Other required python libraries: 
tqdm,
six, 
scipy, 
numpy, 
matplotlib, 
hop,
click,
Cython,
ipython, 
pandas,
pathvalidate,
scipy,
seaborn,
statsmodels,
psutil,
scikit-image,
autograd>=1.3,
emcee==3.0.2,
lightgbm>=2.3.1,
networkx==2.2
Pillow>=7.1.2,
transformers==4.6.1, 
ConfigSpace==0.4.18,
scikit-learn>=0.23.1,
tensorboard==1.15.0,
tensorflow-gpu==1.15.0,

# circuit generator
python circuit_generator.py
# circuit simulation files in the fold simulator


# to perform Bayesian optimization experiments after training D-VAE, the following additional steps are needed.

Install sparse Gaussian Process (SGP) based on Theano:

    cd bayesian_optimization/Theano-master/
    python setup.py install
    cd ../..


# topo-based CktGNN

python train_topo.py --data-name circuit101 --save-interval 100 --save-appendix _CVAE_topo --epochs 300 --lr 1e-4 --model CVAE --nz 56 --batch-size 64 --ng 10000 --cuda_id 0 --hs 501 --topo_t 1
python sgp_regression_topo.py --data-name circuit101  --save-appendix _CVAE_topo --checkpoint 300 --model CVAE --nz 56  --cuda_id 1 --ng 10000 --hs 501  --v1 1
python test_topo.py --data-name circuit101 --save-interval 100 --save-appendix _CVAE_topo --epochs 300 --lr 1e-4 --model CVAE --nz 56 --batch-size 64 --ng 10000 --cuda_id 0 --hs 501 --topo_t 1 --emb_dim 128



python train_topo.py --data-name circuit101  --save-interval 50 --save-appendix _DVAE_topo --epochs 150 --lr 1e-4 --model DVAE --nz 56 --batch-size 64 --cuda_id 0 --ng 10000 --hs 501
python sgp_regression_topo.py --data-name circuit101  --save-appendix _DVAE_topo --checkpoint 150 --model DVAE --nz 56  --cuda_id 2 --ng 10000 --hs 501 --v1 0
python test_topo.py --data-name circuit101 --save-appendix _DVAE_topo --epochs 150 --lr 1e-4 --model DVAE --nz 56 --batch-size 64 --ng 10000 --cuda_id 2 --hs 501 --topo_t 1 --continue-from 150


# general CktGNN
python train_simple.py --data-name circuit101 --save-interval 100 --save-appendix _CVAE --epochs 300 --lr 1e-4 --model CVAE --nz 64 --batch-size 64 --ng 10000 --cuda_id 0 --hs 606
python sgp_regression1.py --data-name circuit101  --save-appendix _CVAE --checkpoint 300 --model CVAE --nz 64  --cuda_id 0 --ng 10000 --hs 606 --emb_dim 20

