import os
import re
import sys
import glob
import json
import traceback
import numpy as np
import gradio as gr
"""
Python 3.9.15
gradio==4.43.0
gradio_client==1.3.0
"""
from PIL import Image
import plotly.graph_objects as go


PLACEHOLDER_IMAGE_PATH = 'placeholder.png'
if not os.path.exists(PLACEHOLDER_IMAGE_PATH):
    img = Image.new('RGB', (256, 256), (50, 50, 50))
    img.save(PLACEHOLDER_IMAGE_PATH, 'PNG')
PLACEHOLDER_IMAGE_PIL = Image.open(PLACEHOLDER_IMAGE_PATH)


def this_will_fail():
    def update_view(method, prompt_id, seed_id, sourc):
        print(f"DEBUG: update_view called with method={method}, prompt_id={prompt_id}, seed_id={seed_id}, source={sourc}")
        return (
            PLACEHOLDER_IMAGE_PIL,
            "This will fail",  
            PLACEHOLDER_IMAGE_PIL, 
            False,                  
            go.Figure(), 
            go.Figure(), 
            go.Figure()  
        )
    
    with gr.Blocks() as demo:
        with gr.Row():
            method_dropdown = gr.Dropdown(['baseline'], value='baseline', label="Method")
            source_dropdown = gr.Dropdown(['test'], value='test', label="Source")
            prompt_slider = gr.Slider(minimum=0, maximum=10, step=1, value=0, label="Prompt")
            seed_slider = gr.Slider(minimum=0, maximum=10, step=1, value=0, label="Seed")
        
        with gr.Row():
            with gr.Column(scale=1):
                gt_image = gr.Image(value=PLACEHOLDER_IMAGE_PIL, label="Image One", height=300)
                info_display = gr.Markdown("Info will appear here.")
                
            with gr.Column(scale=2):
                gen_image = gr.Image(value=PLACEHOLDER_IMAGE_PIL, label="Image Two", height=300)
                label_checkbox = gr.Checkbox(label="Boolean!?", interactive=True)

            with gr.Column(scale=2):
                noise_plot = gr.Plot()
                eig_t1_plot = gr.Plot()
                eig_t20_plot = gr.Plot()
        inputs = [method_dropdown, prompt_slider, seed_slider, source_dropdown]
        outputs = [gt_image, info_display, gen_image, label_checkbox, noise_plot, eig_t1_plot, eig_t20_plot]

        print(f"DEBUG: Setting up events with {len(inputs)} inputs and {len(outputs)} outputs")
        demo.load(update_view, inputs=inputs, outputs=outputs)
        
    demo.launch(share=True)


def this_works_fine():
    def update_view(method, prompt_id, seed_id, sourc):
        print(f"DEBUG: update_view called with method={method}, prompt_id={prompt_id}, seed_id={seed_id}, source={sourc}")
        return (
            "This works fine", 
            False, 
            go.Figure(), 
            go.Figure(), 
            go.Figure()  
        )

    with gr.Blocks() as demo:
        with gr.Row():
            method_dropdown = gr.Dropdown(['baseline'], value='baseline', label="Method")
            source_dropdown = gr.Dropdown(['test'], value='test', label="Source")
            prompt_slider = gr.Slider(minimum=0, maximum=10, step=1, value=0, label="Prompt")
            seed_slider = gr.Slider(minimum=0, maximum=10, step=1, value=0, label="Seed")
        
        with gr.Row():
            with gr.Column(scale=1):
                gt_image = gr.Image(value=PLACEHOLDER_IMAGE_PIL, label="Image One", height=300)
                info_display = gr.Markdown("Info will appear here.")
                
            with gr.Column(scale=2):
                gen_image = gr.Image(value=PLACEHOLDER_IMAGE_PIL, label="Image Two", height=300)
                label_checkbox = gr.Checkbox(label="Boolean!?", interactive=True)

            with gr.Column(scale=2):
                noise_plot = gr.Plot()
                eig_t1_plot = gr.Plot()
                eig_t20_plot = gr.Plot()

        inputs = [method_dropdown, prompt_slider, seed_slider, source_dropdown]
        outputs = [info_display, label_checkbox, noise_plot, eig_t1_plot, eig_t20_plot]

        print(f"DEBUG: Setting up events with {len(inputs)} inputs and {len(outputs)} outputs")
        demo.load(update_view, inputs=inputs, outputs=outputs)
        
    demo.launch(share=True)



if __name__ == "__main__":
    # this_works_fine()
    this_will_fail()