from abc import ABC, abstractmethod
from typing import Dict, List

class BaseMetric(ABC):
    """
    Abstract Base Class for a memorization metric.
    """
    @property
    @abstractmethod
    def name(self) -> str:
        """The name of the metric."""
        pass

    @property
    @abstractmethod
    def metric_type(self) -> str:
        """
        The type of metric. Must be one of ['per_seed', 'per_prompt_across_seeds'].
        """
        pass

    @abstractmethod
    def measure(self, **kwargs) -> Dict:
        """
        Calculates the metric. The arguments required will depend on the metric_type.
        
        - For 'per_seed': Expects intermediates from a single generation.
        - For 'per_prompt_across_seeds': Expects a list of final generated images.
        """
        pass