# Instructions for Running

To build KataGo:
1. in `external/` directory run the following: `wget https://media.katagotraining.org/uploaded/networks/models/kata1/kata1-b40c256-s11840935168-d2898845681.bin.gz`
2. Run `cmake` in `external/KataGo/cpp`, consider the following options
    1. Cuda backend: `cmake . -D USE_BACKEND=CUDA`
    2. Faster option on cpu:  `cmake . -D USE_BACKEND=Eigen -DUSE_AVX2=1 -DCMAKE_CXX_FLAGS='-march=native`
    3. Standard cpu option: `cmake . -D USE_BACKEND=Eigen`
3. Run make: `make`

To build programs:
1. `make go` will build the `go` program, that runs go games
2. `make go-cuda` will build the `go` program using the cuda backend, you should use this if you built KataGo with the cuda backend
3. `make thts-run-toy-env` will build the `thts-run-toy-env` program, that runs the MCTS algorithms on gridworld environments

Running:
1. If you just want to run a game of go:
    1. `./go 000_debug` (this will run a game between PUCT as black, and BST as white)
2. If you want to run games of go between two specific algorithms:
    1. `./go 101_round_robin_9x9 <alg_for_black> <alg_for_white>` where options for algorithms are:
        1. `kata` (PUCT)
        2. `uct`
        3. `puct`
        4. `ments`
        5. `dents`
        6. `rents`
        7. `tents`
        8. `est` (an old name for BST) 
        9. `dents`
3. If you want to run MCTS algorithms on the gridworld environments:
    1. `./thts-run-toy-env <exprid>`
        1. `<exprid>` is one of the following:
            1. `051_fl12_hps` for the Frozen Lake hyper-parameter search
            2. `052_fl12_test` for the Frozen Lake test environment
            3. `091_s6_hps` for the Sailing problem hyper-parameter search
            3. `092_s6_hps` for the Sailing problem test environment

Looking at results:
1. Results for go games run can be found in the `results/go/<exprid>` folder where exprid is either 000_debug, or 101_round_robin_9x9
    1. `match_x.csv` files contains a log for game number x
    2. `results.csv` files contain the cumulative result of the match, over all games (sorry for confusing naming of files!)
2. `python produce_go_graphics.py 9 1 results/go/<exprid>`
    1. Will produce images for the games run, where `<exprid>` is either `000_debug`, or `101_round_robin_9x9` depending on what you ran the `./go` program with
    2. Note that this requires the PyCairo package
    3. Images can be found in the same folder as the `match_x.csv` files
3. `python plot.py <exprid>`
    1. Will produce plots for gridworld experiments (will make a plots folder)
    2. Requires matplotlib and seaborn
    3. `<exprid>` should match the `<exprid>` you ran `./thts-run-toy-env` with
