DEVICES=(0)
SEEDS=(0)
MODEL_SEEDS=(0)

# unlearning task
DATASET=cifar10
TEST_MODE=class
MODEL_NAME=ResNet18

# class-wise forgetting
CLASS_IDX=4
CLASS_IDX_UNLEARN=1
# random data forgetting
SUB_CLASS_NAME="sea" # baby, lamp, mushroom, rocket, sea
SAMPLE_UNLEARN_PER_CLASS=50

# method hyperparameters
METHOD=$1
REMAIN_EPOCHS=20
FORGET_EPOCHS=0
REMAIN_BATCH_SIZE=64
FORGET_BATCH_SIZE=16
LR=2e-4
OPTIMIZER="adam"


SAVE_RESULT_MODEL="--save_result_model"
# uncomment to only run eval_summary
# EVAL_MODE="--eval_mode"

SEP='_'
SEED_SEP='seed'
NOTE=$SEP$BATCH_SIZE$SEP$OPTIMIZER$SEP$LR$SEP
# assert that the length of SEEDS and DEVICES are the same
if [ ${#SEEDS[@]} -ne ${#DEVICES[@]} ]; then
    echo "Length of SEEDS and DEVICES must be the same!"
    exit 1
fi

mkdir -p watch
# if sample mode
if [ $TEST_MODE = "sample" ]; then
    EXP_NAME=$MODEL_NAME$SEP$METHOD$SEP$DATASET$SEP$TEST_MODE$SEP$SAMPLE_UNLEARN_PER_CLASS$SEP$REMAIN_EPOCHS$SEP$FORGET_EPOCHS$SEP$REMAIN_BATCH_SIZE$SEP$FORGET_BATCH_SIZE$SEP$OPTIMIZER$SEP$LR
elif [ $TEST_MODE = "class" ]; then
    EXP_NAME=$MODEL_NAME$SEP$METHOD$SEP$DATASET$SEP$TEST_MODE$SEP$CLASS_IDX$SEP$CLASS_IDX_UNLEARN$SEP$REMAIN_EPOCHS$SEP$FORGET_EPOCHS$SEP$REMAIN_BATCH_SIZE$SEP$FORGET_BATCH_SIZE$SEP$OPTIMIZER$SEP$LR
elif [ $TEST_MODE = "sub_class" ]; then
    EXP_NAME=$MODEL_NAME$SEP$METHOD$SEP$SUB_CLASS_NAME$SEP$REMAIN_EPOCHS$SEP$FORGET_EPOCHS$SEP$REMAIN_BATCH_SIZE$SEP$FORGET_BATCH_SIZE$SEP$OPTIMIZER$SEP$LR
else
    echo "TEST_MODE is not supported"
    exit
fi
mkdir -p final_watch/$DATASET/$TEST_MODE/$EXP_NAME

for i in ${!SEEDS[@]}; do
    SEED=${SEEDS[$i]}
    DEVICE=${DEVICES[$i]}

    MODEL_SEED=${MODEL_SEEDS[$i]}
    CUDA_VISIBLE_DEVICES=$DEVICE python main.py --rnd_seed $SEED \
    --data_name $DATASET --test_mode $TEST_MODE --model_name $MODEL_NAME --model_seed $MODEL_SEED \
    --method $METHOD --lr $LR --optimizer $OPTIMIZER --remain_batch_size $REMAIN_BATCH_SIZE --forget_batch_size $FORGET_BATCH_SIZE --remain_epochs $REMAIN_EPOCHS --forget_epochs $FORGET_EPOCHS \
    --class_idx $CLASS_IDX --class_idx_unlearn $CLASS_IDX_UNLEARN --sub_class_name $SUB_CLASS_NAME --sample_unlearn_per_class $SAMPLE_UNLEARN_PER_CLASS \
    --note $NOTE --unlearn_aug --exp_name $EXP_NAME $SAVE_RESULT_MODEL $EVAL_MODE #> final_watch/$DATASET/$TEST_MODE/$EXP_NAME/seed_$SEED.log 2>&1 &
done

