DEVICES=(0 1 2)
LAYERS=(0 1 2)

CLASS_IDX=4
CLASS_IDX_UNLEARN=1
TRAIN_MODE="mi" # mi, acc
TEST_MODE="class" # class, sample
MODEL_NAME="ViT"
DATASET="cifar100"
MODEL=""
NOTE=""


# DEVICES and LAYERS should be same length
if [ ${#DEVICES[@]} -ne ${#LAYERS[@]} ]; then
    echo "DEVICES and LAYERS should be same length"
    exit 1
fi

mkdir -p infonce/${TRAIN_MODE}/${TEST_MODE}/${DATASET}/${MODEL_NAME}/${NOTE}

# Run the experiments
for i in ${!DEVICES[@]}; do
    DEVICE=${DEVICES[$i]}
    LAYER=${LAYERS[$i]}
    CUDA_VISIBLE_DEVICES=$DEVICE python3 infonce.py --layer $LAYER --class_idx $CLASS_IDX --ckpt checkpoints/$MODEL --class_idx_unlearn $CLASS_IDX_UNLEARN --train_mode $TRAIN_MODE --test_mode $TEST_MODE
done