from copy import deepcopy
from methods.FT import FT
from methods.neggrad import NegGrad, NegGradP
from methods.teacher import Teacher
from methods.cfk import CF1, CF5, CF10, CF20
from methods.euk import EU1, EU5, EU10, EU20
from methods.scrub import SCRUB
from methods.sparse import SPARSE
from methods.salun import SALUN
from methods.RL import RL
from methods.cola import COLA


def run_method(model, retrain_model, loaders, args):
    model = deepcopy(model) # to ensure the original model is not modified
    globals_lower = {k.lower(): v for k, v in globals().items()}
    return globals_lower[args.method.lower()](model, retrain_model, loaders, args).run()
