SEEDS=(0)
DEVICES=(0)
DATA_NAME="cifar10"
MODEL_NAME="ResNet18" # ResNet18, ResNet50, ViT_base
TEST_MODE="sample" # class, sample
SUB_CLASS_NAME="rocket" # "rocket", "mushroom", "baby", "lamp", "sea"
BATCHSIZE=128
EPOCHS=300
CLASS_IDX=4 # starting from CLASS_IDX, the classes to unlearn
CLASS_IDX_UNLEARN=1 # number of classes to unlearn
SAMPLE_UNLEARN_PER_CLASS=50

for idx in ${!SEEDS[@]}; do
    seed=${SEEDS[$idx]}
    device=${DEVICES[$idx]}
    CUDA_VISIBLE_DEVICES=$device python3 pretrain.py --test_mode $TEST_MODE --rnd_seed $seed --data_name $DATA_NAME --sub_class_name $SUB_CLASS_NAME --model_name $MODEL_NAME --remain_batch_size $BATCHSIZE --forget_batch_size $BATCHSIZE --train_epochs $EPOCHS --class_idx $CLASS_IDX --class_idx_unlearn $CLASS_IDX_UNLEARN --sample_unlearn_per_class $SAMPLE_UNLEARN_PER_CLASS
done