# Copyright 2022-2023 OmniSafe Team. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Tasks in Safety-Gymnasium."""

from safety_gymnasium.tasks.ltl.ltl_level0 import LtlLevel0
from safety_gymnasium.tasks.ltl.ltl_level1 import LtlLevel1
from safety_gymnasium.tasks.ltl.ltl_level2 import LtlLevel2
from safety_gymnasium.tasks.ltl.ltl_safety_level2 import LtlSafetyLevel2
from safety_gymnasium.tasks.ltl.ltl_safety_level3 import LtlSafetyLevel3
from safety_gymnasium.tasks.ltl.ltl_safety_level4 import LtlSafetyLevel4
from safety_gymnasium.tasks.ltl.ltl_safety_level5 import LtlSafetyLevel5
from safety_gymnasium.tasks.ltl.ltl_level3 import LtlLevel3
from safety_gymnasium.tasks.ltl.ltl_fixed import LtlFixed
from safety_gymnasium.tasks.safe_navigation.button.button_level0 import ButtonLevel0
from safety_gymnasium.tasks.safe_navigation.button.button_level1 import ButtonLevel1
from safety_gymnasium.tasks.safe_navigation.button.button_level2 import ButtonLevel2
from safety_gymnasium.tasks.safe_navigation.circle.circle_level0 import CircleLevel0
from safety_gymnasium.tasks.safe_navigation.circle.circle_level1 import CircleLevel1
from safety_gymnasium.tasks.safe_navigation.circle.circle_level2 import CircleLevel2
from safety_gymnasium.tasks.safe_navigation.goal.goal_level0 import GoalLevel0
from safety_gymnasium.tasks.safe_navigation.goal.goal_level1 import GoalLevel1
from safety_gymnasium.tasks.safe_navigation.goal.goal_level2 import GoalLevel2
from safety_gymnasium.tasks.safe_navigation.push.push_level0 import PushLevel0
from safety_gymnasium.tasks.safe_navigation.push.push_level1 import PushLevel1
from safety_gymnasium.tasks.safe_navigation.push.push_level2 import PushLevel2
from safety_gymnasium.tasks.safe_navigation.run.run import RunLevel0
from safety_gymnasium.tasks.safe_vision.building_button.building_button_level0 import (
    BuildingButtonLevel0,
)
from safety_gymnasium.tasks.safe_vision.building_button.building_button_level1 import (
    BuildingButtonLevel1,
)
from safety_gymnasium.tasks.safe_vision.building_button.building_button_level2 import (
    BuildingButtonLevel2,
)
from safety_gymnasium.tasks.safe_vision.building_goal.building_goal_level0 import BuildingGoalLevel0
from safety_gymnasium.tasks.safe_vision.building_goal.building_goal_level1 import BuildingGoalLevel1
from safety_gymnasium.tasks.safe_vision.building_goal.building_goal_level2 import BuildingGoalLevel2
from safety_gymnasium.tasks.safe_vision.building_push.building_push_level0 import BuildingPushLevel0
from safety_gymnasium.tasks.safe_vision.building_push.building_push_level1 import BuildingPushLevel1
from safety_gymnasium.tasks.safe_vision.building_push.building_push_level2 import BuildingPushLevel2
from safety_gymnasium.tasks.safe_vision.fading.fading_level0 import (
    FadingEasyLevel0,
    FadingHardLevel0,
)
from safety_gymnasium.tasks.safe_vision.fading.fading_level1 import (
    FadingEasyLevel1,
    FadingHardLevel1,
)
from safety_gymnasium.tasks.safe_vision.fading.fading_level2 import (
    FadingEasyLevel2,
    FadingHardLevel2,
)
from safety_gymnasium.tasks.safe_vision.formula_one.formula_one_level0 import FormulaOneLevel0
from safety_gymnasium.tasks.safe_vision.formula_one.formula_one_level1 import FormulaOneLevel1
from safety_gymnasium.tasks.safe_vision.formula_one.formula_one_level2 import FormulaOneLevel2
from safety_gymnasium.tasks.safe_vision.race.race_level0 import RaceLevel0
from safety_gymnasium.tasks.safe_vision.race.race_level1 import RaceLevel1
from safety_gymnasium.tasks.safe_vision.race.race_level2 import RaceLevel2
