import torch.nn as nn

class MLP(nn.Module):
    def __init__(self, input_size, hidden, out_size):
        super().__init__()
        self.fc1 = nn.Linear(input_size, hidden) 
        self.relu = nn.ReLU()
        self.fc2 = nn.Linear(hidden, out_size)
    
    def forward(self, x):
        if len(x.shape) > 2:
            batch_size = x.shape[0]
            x = x.reshape(batch_size, -1)
        out = self.fc1(x)
        out = self.relu(out)
        out = self.fc2(out)
        return out