#!/bin/bash

# Array of seed values
seeds=(123 224 325 426 527)

# Loop through each seed
for seed in "${seeds[@]}"; do
    echo "Running with seed: $seed"
    
    # Modify the YAML file
    sed -i "s/random_seed: [0-9]*/random_seed: $seed/" configs/huggingface.yml
    
    # Run the Python script
    python main.py
    
    echo "Completed run with seed: $seed"
    echo "------------------------"
done

echo "All runs completed."