import re
import json

# Path to your log file
log_file_path = "FATS_supplement_mnist_cifar_fashion/outputs/2024-11-23/16-55-11/main.log"

# Output JSON file path
output_json_path = "cifar100_5.json"

# Initialize a list to store the extracted values
extracted_data = []

# Regular expression to match the pattern
pattern = r"server_round (\d+), metrics_aggregated \{'accuracy': ([\d.]+)\}"

# Open and read the log file
with open(log_file_path, "r") as file:
    for line in file:
        # Search for matches in each line
        match = re.search(pattern, line)
        if match:
            # Extract round number and accuracy value
            round_number = int(match.group(1))
            accuracy = float(match.group(2))
            extracted_data.append({"round": round_number, "accuracy": accuracy})

# Save the extracted data to a JSON file
with open(output_json_path, "w") as json_file:
    json.dump(extracted_data, json_file, indent=4)

print(f"Extracted data has been saved to {output_json_path}")