
def read_chatml(path):
    """read the chatml formated prompt file"""
    return 

def load_prompt(dataset: str = "gsm8k", 
                model_type: str ="chat",
                format: str = "few_shot_cot", 
                ) -> dict:
    """
    Load prompt from CotHub SPL

    Args:
        dataset (str): dataset name. Defaults to "gsm8k".
            TODO: "mmlu", "bbh", "ceval", "theoremqa", "summedits"
        model_type (str): model type. Defaults to "chat".
            choices: "chat", "completion"
        format (str): prompt format. Defaults to "few_shot_cot".
            choices: "few_shot_direct", "few_shot_cot", "zero_shot_direct", "zero_shot_cot"
    """
    if(model_type == "chat"):
        prompt_dir = "%s/%s/%s.chatml" % (dataset, model_type, format)
    elif(model_type == "completion"):
        prompt_dir = "%s/%s/%s.txt" % (dataset, model_type, format)
    else:
        raise ValueError(f"Invalid model_type {model_type}. Valid choices: 'chat', 'completion'")
    return 