# Current understanding of long context evaluation 

[Yao Fu](https://franxyao.github.io/), University of Edinburgh

[Wangchunshu Zhou](https://michaelzhouwang.github.io/), ETH Zürich

[Hao Peng](https://haopeng-nlp.github.io/), Allen Institute for AI & UIUC


The credibility of chain-of-thought hub comes from very carefully and mediculously dataset selection that can clearly help the development of LLMs. 
For evaluating long-context understanding and reasoning, we studied 7 benchmarks from [Scrolls](https://www.scrolls-benchmark.com/leaderboard), 10 benchmarks from [ZeroScrolls](https://www.zero.scrolls-benchmark.com/leaderboard), the classicial [Long Range Arena](https://arxiv.org/abs/2011.04006), and other related long-context benchmarks. 
Out of 20+ benchmarks we consider, we finally picked 3 datasets: Qspr, QALT and BkSS to join Chain-of-Thought Hub. 
In this document we explain how and why we choose these benchmarks. 

**Table of Content** 
1. [Scrolls and Zero-scrolls](#scrolls-and-zero-scrolls)
2. [Two types of long-context reasoning](#two-types-of-long-context-reasoning)
3. [Model scale and context scale](#model-scale-and-context-scale)
4. [Why not summarization](#why-not-summarization)
5. [The unreasonable effectiveness of FLAN](#the-unreasonable-effectiveness-of-flan)
6. [Conclusion](#conclusion)

## Scrolls and Zero-scrolls



* Scrolls is more about traditional finetuning
* Zero-scrolls is more about modern long-context LLMs

## Two types of long-context reasoning 

* Information selection
* Information aggregation 

## Model scale and context scale

* Use model scale to compensate context length
* Emergent behaivor when considering model scale

## Why not Long-Range Arena

## Why not summarization

* Generic summarization may not be challenging enough
* Query focused summaization and document QA is more realistic 
* Rouge is problematic 

## The unreasonable effectiveness of FLAN
* Flan is not about long-context, but it seems like Flan significantly improves long-context
* It is not just about long-context, Flan almost uniformly improves NLP benchmarks


## Conclusion