# Config accelerate first.
# You may need assign the model path and data path manually.
export CUDA_VISIBLE_DEVICES=0
export TASK_NAME=mnli
export SEED=42
export MODEL_PATH=../data/huggingface/models/roberta-base

export mlm_prob=0.5

export MODEL_TASK=qqp
for TASK_NAME in qqp TwitterPPDB wikitext-103-raw-v1
do
    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob $mlm_prob \
    --seed $SEED \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_pt_${MODEL_TASK}_mlm_prob=${mlm_prob} \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob $mlm_prob \
    --seed $SEED \
    --ft_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_ft_${MODEL_TASK}_mlm_prob=${mlm_prob} \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --delta lora \
    --delta_config ./configs/${MODEL_TASK}/roberta-base_lora/delta.json \
    --delta_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_lora_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_lora_${MODEL_TASK}_mlm_prob=${mlm_prob} \
    --mlm_prob $mlm_prob \
    --seed $SEED \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob $mlm_prob \
    --seed $SEED \
    --ft_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_seed=42 \
    --ckpt_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_vaed_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_dvaed_${MODEL_TASK}_mlm_prob=${mlm_prob} \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob $mlm_prob \
    --seed $SEED \
    --ft_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_seed=42 \
    --ckpt_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_vaep_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_dvaep_${MODEL_TASK}_mlm_prob=${mlm_prob} \
    --do_eval
done


export MODEL_TASK=swag
for TASK_NAME in hellaswag wikitext-103-raw-v1
do
    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob 0.15 \
    --seed $SEED \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_pt_${MODEL_TASK} \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob 0.15 \
    --seed $SEED \
    --ft_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_ft_${MODEL_TASK} \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --delta lora \
    --delta_config ./configs/${MODEL_TASK}/roberta-base_lora/delta.json \
    --delta_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_lora_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_lora_${MODEL_TASK} \
    --mlm_prob 0.15 \
    --seed $SEED \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob 0.15 \
    --seed $SEED \
    --ft_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_seed=42 \
    --ckpt_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_vaed_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_dvaed_${MODEL_TASK} \
    --do_eval

    python test_mlm_conf.py \
    --model_name_or_path $MODEL_PATH \
    --task_name $TASK_NAME \
    --model_task $MODEL_TASK \
    --max_length 256 \
    --per_device_eval_batch_size 8 \
    --mlm_prob 0.15 \
    --seed $SEED \
    --ft_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_seed=42 \
    --ckpt_path ./outputs/ckpts/${MODEL_TASK}/roberta-base_vaep_seed=42 \
    --conf_dir ./outputs/mlm/$TASK_NAME/roberta-base_dvaep_${MODEL_TASK} \
    --do_eval
done