# Config accelerate first.
# You may need assign the model path and data path manually.
export CUDA_VISIBLE_DEVICES=8
export TASK_NAME=swag
export OOD_TASK=hellaswag
export EVAL_SPLIT=val
export MODEL_NAME=roberta-base


  # Train
  accelerate launch run_multiple_choice.py \
    --model_name_or_path $MODEL_NAME \
    --dataset_name $TASK_NAME \
    --max_length 256 \
    --per_device_train_batch_size 32 \
    --learning_rate 1e-5 \
    --num_train_epochs 3 \
    --weight_decay 0.1 \
    --do_train \
    --eval_split $EVAL_SPLIT \
    --checkpointing_steps epoch \
    --seed $SEED \
    --output_dir ./outputs/ckpts/${TASK_NAME}/${MODEL_NAME}_seed=$SEED \
    --conf_dir ./outputs/conf/${TASK_NAME}/$EVAL_SPLIT/${MODEL_NAME}_seed=$SEED

  # OOD Eval
  for epoch in 0 1 2
  do
  python run_multiple_choice.py \
    --model_name_or_path ./outputs/ckpts/${TASK_NAME}/${MODEL_NAME}_seed=${SEED}/epoch=${epoch} \
    --dataset_name $OOD_TASK \
    --eval_split $EVAL_SPLIT \
    --max_length 256 \
    --per_device_train_batch_size 32 \
    --conf_dir ./outputs/conf/${OOD_TASK}/$EVAL_SPLIT/${MODEL_NAME}_seed=${SEED}/epoch=${epoch}
  done
