# Config accelerate first.
# You may need assign the model path and data path manually.
export CUDA_VISIBLE_DEVICES=0
export TASK_NAME=snli
export MODEL_NAME=roberta-base


for TASK_NAME in snli
do
for iter in 5
do
accelerate launch sampling.py \
--model_name_or_path $MODEL_NAME \
--task_name $TASK_NAME \
--max_length 256 \
--per_device_eval_batch_size 1 \
--num_iters $iter \
--output_dir ./outputs/sampling/${TASK_NAME}/roberta-base_vae\
--ckpt_path ./outputs/ckpts/snli/roberta-base_dvaed_seed=42 \

accelerate launch sampling.py \
--model_name_or_path $MODEL_NAME \
--task_name $TASK_NAME \
--max_length 256 \
--per_device_eval_batch_size 1 \
--num_iters $iter \
--rejection \
--output_dir ./outputs/sampling/${TASK_NAME}/roberta-base_vae_rejection \
--ckpt_path ./outputs/ckpts/snli/roberta-base_dvaed_seed=42 \
done
done