import json
import os

def calculate_average_turns(json_file):
    # Load JSON data
    with open(json_file, 'r', encoding='utf-8') as f:
        data = json.load(f)
    
    total_turns = 0
    total_items = len(data)
    
    # Calculate turns for each item
    for item in data:
        # Each turn consists of a question and answer, so divide by 2
        turns = len(item['history']) // 2
        total_turns += turns
    
    # Calculate average
    average_turns = total_turns / total_items
    return average_turns, total_turns, total_items

def calculate_all_averages(base_path):
    files = ["math.json", "biology.json", "physics.json", "chemistry.json"]
    total_all_turns = 0
    total_all_items = 0
    
    # Calculate for each file
    for file in files:
        file_path = os.path.join(base_path, file)
        avg_turns, total_turns, total_items = calculate_average_turns(file_path)
        print(f"{file}: Average turns = {avg_turns:.2f}")
        
        # Accumulate totals
        total_all_turns += total_turns
        total_all_items += total_items
    
    # Calculate overall average
    overall_avg = total_all_turns / total_all_items
    print(f"\nOverall average turns: {overall_avg:.2f}")

# Usage
if __name__ == "__main__":
    base_path = ''
    calculate_all_averages(base_path)