import json
import re
import argparse

def main(input_file2):
    # 读取第一个JSON文件

    # 打开文件并读取数据
    with open(input_file2, 'r', encoding='utf-8') as f:
        data = [json.loads(line) for line in f]

    # 初始化计数器
    zero_count = 0

    # 遍历每个条目
    for item in data:
        state = item.get('state', '')
        matches = re.findall(r'（(\d)）', state)  # 匹配中文括号中的数字
        zero_count += matches.count('0')  # 计算 '0' 的个数

    print(f"所有state中number为0的个数是：{zero_count}")

    total_knowledge_points = 0
    count_1 = 0
    count_0 = 0
    total_explained_points = 0  # 新增：总讲解次数
    zero_explained_count = 0    # 新增：讲解0的次数

    # 读取并处理第二个JSON文件
    with open(input_file2, 'r') as f:
        for line in f:
            data = json.loads(line)
            seen_in_result = set()
            for result in data['results']:
                for item in result:
                    if item.get('is_in_knowlege_tree') != 'yes':
                        continue

                    for point in item['knowledge_point']:
                        # 计算总讲解次数
                        total_explained_points += 1
                        
                        # 判断是否为0结尾
                        if re.search(r'（0）$', point) or re.search(r'\(0\)$', point):
                            zero_explained_count += 1
                            
                        point_key = point.rsplit(' （', 1)[0]
                        if point_key not in seen_in_result:
                            seen_in_result.add(point_key)
                            total_knowledge_points += 1
                            if re.search(r'（1）$', point) or re.search(r'\(1\)$', point):
                                count_1 += 1
                            elif re.search(r'（0）$', point) or re.search(r'\(0\)$', point):
                                count_0 += 1
                            else:
                                count_0 += 1

    print(f"Total knowledge points: {total_knowledge_points}")
    print(f"Count of (1): {count_1}")
    print(f"Count of (0): {count_0}")
    print(f"Total explained points: {total_explained_points}")  # 新增输出
    print(f"Zero explained count: {zero_explained_count}")      # 新增输出

    # 计算指标
    precision = count_0 / total_knowledge_points if total_knowledge_points > 0 else 0
    zero_explained_ratio = zero_explained_count / total_explained_points if total_explained_points > 0 else 0  # 新增指标

    # 输出结果
    print(f"Precision: {precision:.4f}")
    print(f"Zero explained ratio: {zero_explained_ratio:.4f}")  # 新增输出

if __name__ == "__main__":
    input2 = ""
    main(input2)