#逻辑性


#总体性能
import json
import os
import argparse
from langchain.chat_models import ChatOpenAI
from langchain import PromptTemplate
from langchain.prompts import ChatPromptTemplate, MessagesPlaceholder
from langchain_community.chat_models.tongyi import ChatTongyi
from utils import extract_json


template = """
You are a scoring expert. The teacher is tutoring a student through a dialogue, and you will score the teacher's logic when tutoring the student.
Logic: The teacher should demonstrate a clear and coherent thought process during tutoring, and the content should be presented step by step, avoiding jumping explanations or confusing information transmission. The teacher needs to be able to reasonably arrange the content of the tutoring according to the nature of the question and the student's understanding, so that the student can gradually understand the question by following the teacher's train of thought.
**Scoring criteria**: 0-5, of which:
0: The tutoring process is logically confusing, the teacher's explanations lack a clear sequence and are even wrong, and the student cannot understand the train of thought.
3: The teacher's explanations are generally logical, but sometimes the train of thought is not clear or jumps around a lot.
5: The teacher's explanations are logically rigorous and clear, the steps are organized, and they can help the student gradually understand the problem. The student can easily follow the teacher's train of thought.
Note: Whether or not the student ultimately answers the question correctly does not affect your score. You need to pay attention to the logical structure of the teacher's tutoring process and the clarity of the explanations.
**Input**:
Problem: {problem}
Answer: {answer}
Tutorial history: {dialogue}

**Output**: Give the score and the corresponding reason for the score. The reason should be concise (one sentence). According to the following format:
The output should be a Markdown code snippet in the following format, including the surrounding tags “```json” and “```”
{{
“score”: “0-5”,
“reason“: ‘Reason for the score’,
}}"""




# gpt-3.5-turbo-1106
llm = ChatOpenAI(
    model_name="gpt-4o",
    temperature=0,
    openai_api_base="https://api.xty.app/v1",
    max_tokens=4096
)

def extract_score_from_text(text):
    import re
    match = re.search(r'\b[0-5]\b', text)
    return int(match.group(0)) if match else 0

def load_and_process_json(file_path, output_dir='output', batch_size=10, output_file='output.json'):
    # Ensure output directory exists
    os.makedirs(output_dir, exist_ok=True)
    
    # Create full output path
    output_path = os.path.join(output_dir, output_file)
    
    # Load JSON data
    with open(file_path, 'r', encoding='utf-8') as f:
        data = json.load(f)
    
    # Open output file in write mode
    with open(output_path, 'w', encoding='utf-8') as f:
        # Process in batches
        for i in range(0, len(data), batch_size):
            batch = data[i:i + batch_size]
            batch_records = []
            dialogues = []
            
            # Process each item in batch
            for item in batch:
                tutor_list = item.get('tutor', [])
                history = []
                for tutor in tutor_list:
                    teacher_res = tutor.get('teacher_res', '')
                    history.append(f"Teacher: {teacher_res} |EOM|")
                    stu_res = tutor.get('stu_res', '')
                    if stu_res:
                        if stu_res.startswith('state:'):
                            stu_res = stu_res.split(':', 1)[1].lstrip('0123456789').strip()
                    
                        history.append(f"Student: {stu_res} |EOM|")
                
                dialogue = " ".join(history)
                dialogues.append(dialogue)
                test_prompt = PromptTemplate.from_template(template).partial(
                    problem=item.get('question', ''),
                    answer= item.get('answer',''),
                    dialogue=dialogue
                ).format()
                batch_records.append(test_prompt)
            
            # Process batch with LLM
            llm_response = llm.batch(batch_records)
            results = [extract_score_from_text(str(response)) for response in llm_response]
            ress = extract_json(llm_response)
            # Write results as JSON Lines
            for item, score, llm_r, dialogue in zip(batch, results, ress, dialogues):
                if int(score)<4:
                    
                    record = {
                        'problem': item.get('question', ''),
                        'score': score,
                        'text': llm_r[0]['score'],
                        "resson" : llm_r[0]['reason'],
                        'dialogue': dialogue
                    }
                    f.write(json.dumps(record, ensure_ascii=False) + '\n')
                else:
                    record = {
                        'problem': item.get('question', ''),
                        'score': score,
                        'text': llm_r[0]['score'],
                        "resson" : llm_r[0]['reason'],
                    }
                    f.write(json.dumps(record, ensure_ascii=False) + '\n')

            print(f"Processed batch {i//batch_size + 1}/{len(data)//batch_size + 1}")
    
    print(f"All results saved to {output_path}")

def main():
    # Set up argument parser
    parser = argparse.ArgumentParser(description='Process overall proficiency evaluation for teaching dialogues')
    parser.add_argument('--input', required=True, help='Path to input JSON file')
    parser.add_argument('--output_dir', default='output', help='Directory to save output files')
    parser.add_argument('--output_file', default='output.json', help='Output file name')
    parser.add_argument('--batch_size', type=int, default=10, help='Batch size for processing')
    
    # Parse arguments
    args = parser.parse_args()
    
    # Process the file
    load_and_process_json(
        file_path=args.input,
        output_dir=args.output_dir,
        output_file=args.output_file,
        batch_size=args.batch_size
    )

if __name__ == '__main__':
    main()




