from langchain_core.prompts import ChatPromptTemplate, MessagesPlaceholder
from langchain_community.chat_models import ChatOpenAI

class Student_agent(object):

    def __init__(self,llm):
        self.student_chat_prompt_template = ChatPromptTemplate.from_messages([
            ("system", """You are a high school student who encounters a problem you don’t know how to solve (Problem 1). Before providing tutoring, the teacher asks another question (Problem 2) to diagnose your understanding of a certain knowledge point. Your task is to respond in a way that reflects your current level of understanding based on the given problem and knowledge state network, helping the teacher diagnose your grasp of the knowledge point.

Rules:
1. Knowledge State Network: The number following each knowledge point represents your understanding level. (1) means mastered, (0) means not mastered.
2. Knowledge points being tested: The knowledge points for Problem 2 are listed below. You can refer to your knowledge state network to assess your mastery of these knowledge points. Your response should be consistent with your understanding: if you have mastered the knowledge point, you should provide the answer to Problem 2. If you haven't mastered the knowledge point, you can simply say you don’t know how to solve this question.
3. Diagnosis purpose: This phase aims to diagnose your level of understanding, and you are not expected to acquire new knowledge. Do not mention knowledge points that the teacher hasn’t asked about.
4. Response requirement: Answer the teacher’s question in one simple and concise sentence.
5. Language requirement: Please respond in Chinese.

Input:  
# Unsolved Problem (Problem 1): {problem}  
# Knowledge State Network: {state}  
# Teacher's Question (Problem 2): {history}  
# Knowledge Points Tested by Problem 2: {concept}  
Your Answer:  
"""), # 使用MessagePlaceholder来动态传递历史记录
        ])
        
        self.llm = llm
    def forward(self,question,state, teacher_ques, concept):
        student_chain = self.student_chat_prompt_template | self.llm
        student_res = student_chain.invoke({"problem": question, "state": state, "history": teacher_ques, "concept": concept})
        # print(f"Student Prompt (Round {i}): {student_prompt}")  # 输出学生的 prompt
        return student_res.content


        