from langchain_core.prompts import ChatPromptTemplate
from langchain_community.chat_models import ChatOpenAI

import re

class TeacherAgentResponse:
    def __init__(self, step1, step2, step3, step4, step5):
        self.step1 = step1
        self.step2 = step2
        self.step3 = step3
        self.step4 = step4
        self.step5 = step5

    def __repr__(self):
        return f"TeacherAgentResponse(step1={self.step1}, step2={self.step2}, step3={self.step3}, step4={self.step4}, step5={self.step5})"

def extract_steps(response_str):
    # 正则表达式匹配每个步骤的内容
    step_pattern = re.compile(r"<step(\d)> (.*?)(?=<step\d>|$)", re.DOTALL)

    # 找到所有的匹配项
    steps = re.findall(step_pattern, response_str)

    # 构建字典来存储每个步骤
    steps_dict = {}
    for step in steps:
        step_number = int(step[0])
        step_content = step[1].strip()
        steps_dict[f"step{step_number}"] = step_content

    # 使用字典创建对象
    return TeacherAgentResponse(**steps_dict)


class Teacher_agent(object):
    
    def __init__(self,llm):
        #认知诊断部分，题目生成
        self.teacher_chat_prompt_template = ChatPromptTemplate.from_messages([
            ("system", '''Role: You are a teacher who specializes in diagnosing students' mastery of knowledge points through questions. Now, a student is unable to solve a question, and you need to generate a new question to quickly assess the student's mastery of a specific knowledge point. The input includes:
            - A question.
            - A detailed solution to the question.
            - The knowledge point to be diagnosed.
            - The knowledge point chain (used to infer the meaning of the knowledge point, and when generating the question, do not involve any subsequent knowledge points in the chain).
            - (Optional) History: If there is a history, it indicates that the previous question or answer might have issues, and you need to reflect and optimize the generated question to ensure its correctness. If there is no history, you do not need to consider it.
            
            Task: According to the input content, let's think step by step and complete the following tasks:

            1. Based on the question, solution, and knowledge point chain, output the level of knowledge assessed by the question (Memory/Understanding/Application).
            2. Based on the assessment level, choose an appropriate question type: (Memory: design a fill-in-the-blank question; Understanding: design a multiple-choice question; Application: design a multiple-choice question, calculation question, or open-ended question).
            3. Generate a question that only involves the knowledge point to be diagnosed, with difficulty not higher than the original question.
            4. Provide a concise explanation of the generated question.
            5. Generate the final answer.

            **Output**: 
            Output must strictly follow the format below:
            <step1> Assessment Level: xxx
            <step2> Question Type: xxx
            <step3> Question: xxx
            <step4> Explanation: xxx
            <step5> Answer: xxx

            **Example Output 1**:
            <step1> Assessment Level: Understanding
            <step2> Question Type: Multiple-Choice Question
            <step3> Question: In uniform decelerated motion, when the velocity of an object decreases to zero, the characteristic of the acceleration is:
            A. Acceleration is in the same direction as velocity  
            B. Acceleration is in the opposite direction to velocity  
            C. Acceleration is always positive  
            D. Acceleration is zero  
            <step4> Explanation: In uniform decelerated motion, acceleration is in the opposite direction to velocity, causing the velocity to gradually decrease to zero.
            <step5> Answer: B

            **Example Output 2**:
            <step1> Assessment Level: Memory
            <step2> Question Type: Fill-in-the-Blank Question
            <step3> Question: Virus _ cell structure.
            <step4> Explanation: Viruses do not have a cell structure.
            <step5> Answer: Does not exist

            # Input
            Question: {problem}
            Solution: {analysis}
            Knowledge Point to Diagnose: {node_name}
            Knowledge Point Chain: {path}
            History (Optional): {history}

            # Your Output:

        '''),
        ])
        
        self.llm = llm
    def forward(self,node_name, path, question, analysis, history):
        teacher_chain = self.teacher_chat_prompt_template | self.llm

        max_retries = 3  # Maximum number of retries
        retry_count = 0
        
        while retry_count < max_retries:
            try:
                teacher_response = teacher_chain.invoke({
                    "problem": question,
                    "analysis": analysis,
                    "path": path,
                    "node_name": node_name,
                    "history": history
                })
                # Try to extract steps
                response_obj = extract_steps(teacher_response.content)
                # If successful, break the loop
                break
            except Exception as e:
                retry_count += 1
                if retry_count >= max_retries:
                    # If max retries reached, raise the exception
                    raise Exception(f"Failed to extract steps after {max_retries} attempts. Last error: {str(e)}")
                # Otherwise, continue to retry
                continue

        # 打印提取出的步骤内容
        print(response_obj)
        return response_obj, teacher_response.content
