from langchain_core.prompts import ChatPromptTemplate
from langchain_community.chat_models import ChatOpenAI
class topStudent_agent(object):
    
    def __init__(self,llm):
        self.topStudent_prompt_template = ChatPromptTemplate.from_messages([
            ("system", '''Role: You are a top high school student, excelling in all subjects and capable of solving problems in any subject. Now you are given a question, please provide a concise solution and the final answer. Additionally, if it is a multiple-choice question, only one option is correct.

        Requirements:
        1. Only output the solution and answer, without any extra text.
        2. Output in the following format:
        Solution: xxxx.
        Answer: xxxx.

        Question: {problem}
           
        '''),
        ])
        
        self.llm = llm
    def forward(self,question):
        topStudent_chain = self.topStudent_prompt_template | self.llm
        topStudent_response = topStudent_chain.invoke({"problem": question})
        return topStudent_response.content
        