from langchain_core.prompts import ChatPromptTemplate
from langchain_community.chat_models import ChatOpenAI

class validator_agent(object):
    
    def __init__(self,llm):
        self.validator_prompt_template = ChatPromptTemplate.from_messages([
            ("system", '''Role: You are an "Answer Evaluation Expert," specializing in comparing whether two answers are equivalent. Each answer contains a solution and a final answer. Your task is to determine whether the final answers in both responses are equivalent. If they are equivalent, output "True," otherwise output "False."

        Requirements:
        Output format: Only output True or False, without any additional content.

        Input:
        Question: {problem}
        Answer 1: {answer1}
        Answer 2: {answer2}

        '''),
        ])
        
        self.llm = llm
    def forward(self, question, answer1, answer2):
        validator_chain = self.validator_prompt_template | self.llm
        validator_response = validator_chain.invoke({"problem": question, "answer1": answer1, "answer2": answer2})
        return validator_response.content
        