import os
import json
from langchain.chat_models import ChatOpenAI
from langchain.prompts import ChatPromptTemplate, MessagesPlaceholder
from pydantic import BaseModel, Field
from langchain import PromptTemplate
from langchain_community.chat_models.tongyi import ChatTongyi
import copy
from utils import extract_json
from typing import List
import re
import random 

from langchain.schema import (
    BaseMessage,
    HumanMessage,
    AIMessage,
    ChatMessage
)

class Judgements(object):
    def __init__(self, llm):
        #teacher：选择策略，生成响应。输入：上一轮策略，目的，学生响应 本轮目的，策略，具体响应
        self.prompt1 = """Role: You are an intelligent educational assistant responsible for judging the type of behavior of the teacher based on the conversation history between the student and teacher and the student's knowledge mastery status. Based on the conversation history and student knowledge state, follow these steps:

        ### Input Content:
        1. **Conversation History:**
        {history}
        
        2. **Student Knowledge State:**
        {status}  
        In this, the '#' symbol indicates the hierarchical structure of the knowledge points, and the number following the knowledge point indicates the student's mastery status: (1) means mastered, (0) means not mastered.

        ### Task Description:
        1. The **teacher's last behavior** can be classified into three categories:
        - **Category 1:** First explains the knowledge or provides methods/strategies, then asks a question.
        - **Category 2:** Directly asks a question (without providing any methods, strategies, or hints).
        - **Category 3:** Other behaviors.

        2. **Judgment Process:**
        - If the teacher's behavior is **Category 2: Direct Question**, you need to determine whether the student can answer the question based on their knowledge state. If the student can answer, output "Category 2 Can". If the student cannot answer, output "Category 2".
        - For the other two categories (Category 1 and Category 3), just output the behavior category without additional analysis.

        ### Output Requirements:
        - Output the teacher's behavior category. If the behavior is **Category 2** and the student can answer the question, output "Category 2 Can", otherwise, just output "Category 2".
        - Output should avoid any irrelevant content (such as analysis, greetings, etc.).

        ### Example Output:
        - Example 1: Category 2 Can
        - Example 2: Category 2
        - Example 3: Category 1
        - Example 4: Category 3

        """



        self.prompt2="""Role: You are a skilled and cautious student knowledge state updater.

        #### Instruction:
        Based on the provided context, analyze the student's current knowledge state and the last two rounds of dialogue between the student and teacher. It is known that the student can correctly answer the teacher's last question. Your task is to determine whether the student has mastered certain knowledge points that were previously marked as not mastered.

        #### Context:
        - **Student Knowledge State:**  
        ------------------------------------  
        {state}  
        ------------------------------------  
        In the knowledge state table, the number of '#' symbols indicates the hierarchical structure of knowledge points, and the number following the knowledge point (1 or 0) represents the student's mastery status: (1) means mastered, (0) means not mastered.

        - **Conversation History:**  
        {history}

        ### Task:
        Based on the teacher's last question, and knowing that the student answered it correctly, carefully analyze the knowledge points that must have been mastered to answer the last question correctly. Evaluate whether the student has mastered the knowledge points previously marked as 0. If so, update the related knowledge point from 0 to 1, leaving other parts of the state unchanged. If uncertain, leave the state unchanged.

        #### Output Requirements:
        The output should be in the following Markdown format, including the "```json" markers before and after the code, and should include:
        ```json
        {
            "need_update": "yes/no",
            "state_tree": "knowledge state tree"
        }
"""

        self.llm =llm
    #输入：
    # 最后两轮的对话历史，当前的知识状态
    def forward(self, histories, states):
        ## 1. 教师的最后一轮行为
        updated_states = copy.deepcopy(states)
        final1_prompts = []
        final2_prompts = []
        for history, state in zip(histories, states):
            final_prompt1 = PromptTemplate.from_template(self.prompt1).partial(history=history, status = state).format()
            final1_prompts.append(final_prompt1)
        prompt1_res = self.llm.batch(final1_prompts)

        ## 2.初始化学生响应状态
        # 判断每一个属于哪个类别，对于类别为“类别二 能”的情况，需要执行下面代码：
        numbers_1=[2,3]
        numbers_2=[1,3,4]
        label = []
        need_update = ['no']*len(histories)
        for i, (history, state) in enumerate(zip(histories, states)):
            if "Category 2 Can" in prompt1_res[i].content:
                final_prompt2 = PromptTemplate.from_template(self.prompt2).partial(history=history, state=state).format()
                final2_prompts.append(final_prompt2)
                label.append(4)
                
            elif "Category 2" in prompt1_res[i].content:
                tmp = numbers_1[random.randrange(len(numbers_1))]
                label.append(tmp)
            elif "Category 1" in prompt1_res[i].content:
                tmp = numbers_2[random.randrange(len(numbers_2))]
                if tmp == 4:
                    final_prompt2 = PromptTemplate.from_template(self.prompt2).partial(history=history, state=state).format()
                    final2_prompts.append(final_prompt2)
                label.append(tmp)
            elif "Category 3" in prompt1_res[i].content:
                label.append(5)

        if final2_prompts:
            tmp = self.llm.batch(final2_prompts)
            prompt2_res = extract_json(tmp)
            # 按顺序从 final2_prompts 中选择一个赋值
            prompt2_res_index = 0
            for i in range(len(prompt1_res)):
                if ("类别一" in prompt1_res[i].content and label[i] == 4) or "类别二 能" in prompt1_res[i].content:
                    if prompt2_res[prompt2_res_index][0]['need_update']=='yes':
                        updated_states[i] = prompt2_res[prompt2_res_index][0]['state_tree']
                        need_update[i] = 'yes'

                    prompt2_res_index += 1
        
        return updated_states, label, need_update