import os
import json
from langchain.chat_models import ChatOpenAI
from langchain import PromptTemplate
from utils import extract_json


#指定学生具体操作的版本
class Student(object):
    def __init__(self, llm):
        #teacher：选择策略，生成响应。输入：上一轮策略，目的，学生响应 本轮目的，策略，具体响应
        self.template = """You are a student, and there is a question you cannot solve. The teacher is providing you with guidance.

        The question is:
        ----------------------------------
        {problem}
        ----------------------------------

        Your knowledge status is:
        -----------------------------------
        {state}
        ------------------------------------

        In the knowledge status, the number of '#' represents the hierarchical structure of knowledge points, and the number after each knowledge point indicates your mastery level: (1) means mastered, (0) means not mastered.

        History record:
        -------------------------------------
        {history}
        -------------------------------------

        You need to respond to the teacher's latest message. Your **response strategy** is:  
        **{type}**

        An example of this state is:
        -------------------------------------
        {type_example}
        -------------------------------------

        Please combine your knowledge status and respond to the teacher's last message in a way that aligns with your **response strategy**, ensuring that your response is not contradictory to your knowledge status.

        **Note**: Your response must not contradict your knowledge status and should adhere to your response strategy.

        Output format:  
        The output should be in the following format, wrapped in "```json" and "```" as a Markdown code block:  
        {{ "response": "Your response" }}
"""
        
        self.right_ans = """You are a student, and there is a question you cannot solve. The teacher is providing you with guidance.

        The question is:
        ----------------------------------
        {problem}
        ----------------------------------

        History record:
        -------------------------------------
        {history}
        -------------------------------------

        You need to respond to the teacher's latest message. Your **response strategy** is:  
        **{type}**

        An example of this state is:
        -------------------------------------
        {type_example}
        -------------------------------------

        Here is a key step in the problem-solving process for your reference:
        {steps}

        Please combine your knowledge status and respond to the teacher's last message in a way that aligns with your **response strategy**.

        Output format:  
        The output should be in the following format, wrapped in "```json" and "```" as a Markdown code block:  
        {{ "response": "Your response" }}
"""
        self.template_others = """You are a student, and there is a question you cannot solve. The teacher is providing you with guidance.

        The question is:
        ----------------------------------
        {problem}
        ----------------------------------

        Your knowledge status is:
        -----------------------------------
        {state}
        ------------------------------------

        In the knowledge status, the number of '#' represents the hierarchical structure of knowledge points, and the number after each knowledge point indicates your mastery level: (1) means mastered, (0) means not mastered.

        History record:
        -------------------------------------
        {history}
        -------------------------------------

        Please respond to the teacher's latest message based on your knowledge status. Your response must not contradict your knowledge status.

        Output format:  
        The output should be in the following format, wrapped in "```json" and "```" as a Markdown code block:  
        {{ "response": "Your response" }}
"""

        self.llm = llm
        # self.llm = ChatTongyi(model='qwen-max')
        self.types = [
            "You don't understand a certain knowledge point or process explained by the teacher (you have some confusion about the content explained by the teacher, so you ask questions related to it)",
            "You try to answer the teacher's question, but your answer is incorrect (generate an incorrect answer)",
            "Your knowledge mastery is weak, and you can't answer the teacher's question",
            "You can correctly answer the teacher's question.",
            "Others"
]

        sit1 = """# Question: "3. (6 points) To observe plasmolysis, RNA, and fat under a light microscope, which of the following sets of materials should be chosen? (    )  
        A. Rice endosperm and peanut cotyledons  
        B. Geranium leaves and rice endosperm  
        C. Purple onion and peanut cotyledons  
        D. Geranium leaves and purple onion"

        # Dialogue history: [Teacher] Endosperm cells do not contain vacuoles, so they cannot be used to observe plasmolysis.  
        # Knowledge status:  
        # Plant cell structure and function (1)  
        # Organelles and substance storage (1)  
        # Vacuole function (0)  

        # Your response: Why can't plasmolysis be observed if there are no vacuoles?
"""
             


        sit2 = """# Question: "1. (6 points) Which of the following statements about cells is correct? (    )  
        A. Viruses are a type of organism with cellular structure  
        B. Cyanobacteria cells have a nucleus, and their DNA molecules are circular  
        C. The cell cycle duration is the same for all human cells  
        D. Both the endoplasmic reticulum membrane and the Golgi apparatus membrane have fluidity"

        # Dialogue history: [Teacher] Do viruses have a cellular structure?  
        # Knowledge status:  
        # Cell biology (1)  
        # Viruses (0)  

        # Your response: Yes, viruses have a cellular structure.
"""
             


        sit3 = """# Question: "2. (6 points) A particle initially moves with uniform linear motion, and from a certain moment, a constant force acts on it. After that, the kinetic energy of the particle may ( $)$  
        A. Keep increasing  
        B. Gradually decrease to zero, then gradually increase  
        C. Gradually increase to a maximum value, then gradually decrease  
        D. Gradually decrease to a non-zero minimum value, then gradually increase"

        # Dialogue history: [Teacher] What does uniform linear motion of an object indicate?  
        # Knowledge status:  
        # Mechanics (1)  
        # Kinetic energy (1)  
        # Uniform linear motion (0)  

        # Your response: Teacher, I don't know what "uniform linear motion" is.
"""
             
             

        sit4 = """
        # Question: "6. (3 points) Under certain temperature and pressure conditions, 400 mL of O2 is introduced into a mixture of 100 mL CH4 and Ar. After ignition, the mixture undergoes complete combustion, and the final volume of dry gas obtained is 460 mL. What is the molar ratio of CH4 to Ar in the original mixture? (    )  
        A. 1: 4  
        B. 1: 3  
        C. 1: 2  
        D. 1: 1"

        # Dialogue history: [Teacher] What is the reaction equation between CH4 and O2 under complete combustion conditions?  
        # Knowledge status:  
        # Gas reaction equations (1)  
        # Complete combustion reactions (1)  
        # Moles and volume relationships (0)  

        # Your response: I know, it is $\\mathrm{CH}_{4}+2 \\mathrm{O}_{2} \\rightarrow \\mathrm{CO}_{2}+2 \\mathrm{H}_{2} \\mathrm{O}$.

        """

        self.examples = [sit1, sit2, sit3, sit4]

    def forward(self, problems, states, histories, types, steps):
        final_prompts = []
        for problem, state, history, type, step in zip(problems, states, histories, types, steps):  
            if type == 5:
                student_prompt = PromptTemplate.from_template(self.template_others).partial(problem=problem,
                state=state,
                history=history).format()
            elif type == 4:
                (step_question, step_analysis) = step
                student_prompt = PromptTemplate.from_template(self.right_ans).partial(problem=problem,
                history=history, type = self.types[type-1], type_example=self.examples[type-1], steps = step_question + step_analysis).format()
            else:
                student_prompt = PromptTemplate.from_template(self.template).partial(problem=problem,
                    state=state,
                    history=history,
                    type = self.types[type-1], type_example=self.examples[type-1]).format()
            final_prompts.append(student_prompt)
        
        tmp = self.llm.batch(final_prompts)
        responses = extract_json(tmp)
        return responses
