# 跟踪学生状态的教师
import os
import json
from langchain.chat_models import ChatOpenAI
from langchain_community.chat_models import ChatZhipuAI
from langchain.prompts import ChatPromptTemplate, MessagesPlaceholder

from pydantic import BaseModel, Field
from utils import extract_json
import faiss
import numpy as np

import re
from langchain import PromptTemplate



class Teacher(object):
    def __init__(self,llm):
        
        #学生知识状态判断
        self.student_steps_predict = """
            You are a professional and rigorous teacher who can comprehensively evaluate a student's knowledge mastery. Based on the student's knowledge state, strictly judge whether they can answer the current substep question. Only when the student has mastered all the necessary knowledge points to solve the current substep can they be considered capable of answering the question.

        Input:
        1. **Question**: {question}
        2. **Substep Question**: {step_question}
        3. **Substep Question Analysis**: {step_analysis}
        4. **Student Knowledge Status Tree**: {state}  
        - Each knowledge point has a number after it indicating the student's mastery level: 0 means not mastered, 1 means mastered.

        Task:  
        Based on the **substep question** and **substep question analysis**, analyze all the knowledge points needed to solve the current substep question. Compare them with the student's knowledge status tree and determine whether the student's current knowledge points allow them to answer the **substep question**. If they can, output "yes"; otherwise, output "no", and list the knowledge points in the knowledge status tree that the student has not mastered and that prevent them from answering the current substep.

        Output format:  
        The output should be in the following format, wrapped in "```json" and "```" as a Markdown code block:  
        {{  "predict": "yes/no",  // Whether the student can answer the current substep question  
        "reason": "Reason",  // A brief explanation of why the student can or cannot answer the question  
        "mastered_knowledge": ["Knowledge point 1", "Knowledge point 2", ...],  // Knowledge points the student has mastered and needs to answer this substep, if any  
        "missing_knowledge": ["Knowledge point 1", "Knowledge point 2", ...]  // Knowledge points not mastered that prevent the student from answering, if any }}

        Output:
"""

        self.teacher_strategy_predict_ini = """
            You are a teacher helping a student answer the following question. This question has been broken down into several steps, and each step may require multiple rounds of dialogue to fully solve. You need to guide the student step by step based on their understanding.

        **Question**:
        ##
        {question}
        ##

        **Current Step Breakdown**:
        ##
        {ques}
        ##

        **Step Breakdown Analysis**:
        ##
        {ans}
        ##

        **Student Understanding Prediction**:
        You predict the student's understanding of this step as:
        {predict}
        "Can solve independently" means the student has mastered the knowledge for this step and can answer directly;
        "Lacks understanding" means the student needs more help and requires heuristic guidance.

        **Missing Knowledge Points**:
        {missing_knowledge}

        **Task**: Based on the student's understanding and missing knowledge points, choose and output the appropriate tutoring strategy for this round.
        **Note**:
        1. If the student has multiple missing knowledge points, do not solve them all at once. Gradually guide the student to resolve the issues over multiple rounds.
        2. If the student is predicted to "solve independently," directly ask the question for the current breakdown step.
        3. Focus on guidance, with explanations as a supplement: Encourage the student to think for themselves through various strategies (asking questions, simplifying problems, etc.), and only provide explanations when they encounter real difficulties.

        Please choose one of the following strategies appropriate for the current step:

        a) Explain a concept: Explain a concept or method to the student without directly providing the answer to the problem.
        b) Suggest a strategy: Guide the student to use a method or strategy to advance their thinking.
        c) Confirm the student's answer: Acknowledge the student's correct answer and encourage them to continue thinking for the next step.
        d) Correct the student's answer: Gently point out the student's mistake and guide them to reexamine the problem for self-correction.
        e) Ask an open-ended question: Trigger deeper thinking or let the student complete the next step of the solution.
        f) Ask a closed-ended question: Test the student's understanding and memory, focusing on specific knowledge points.
        g) Simplify the problem: Break down the problem into a simpler form to help the student focus on the core.
        h) Break down the problem: Split the problem into smaller parts to help the student solve it step by step.
        i) Other

        Output format:
        The output should be in the following format, wrapped in "```json" and "```" as a Markdown code block:
        {{
        "strategy": "Your strategy (output strategy number)",
        "purpose": "Your purpose (e.g., testing, explaining a knowledge point/concept/skill, etc., do not set multiple purposes)"
        }}

        """

#教师策略选择
        self.teacher_strategy_predict = """
            You are a teacher, currently guiding a student through solving the following problem. The problem has been broken down into multiple steps, and each step may require several rounds of dialogue to fully solve. You should guide the student step-by-step in solving the "current breakdown step" of the problem according to their understanding.

        **Problem**: 
        ##
        {question}
        ##

        **Current Breakdown Step**:
        ##
        {ques}
        ##

        **Breakdown Step Explanation**:
        ##
        {ans}
        ##

        **Student Understanding Prediction**:
        You predict the student's understanding level of the current step as:
        {predict}
        “Can solve independently” means the student has mastered the step and can directly answer without further help;
        “Lacks understanding” means the student needs more help and should be guided through the step.

        **Missing Knowledge**:
        {missing_knowledge}

        **Dialogue History**:
        ##
        {history}
        ##

        **Previous Strategy**:
        ##
        {previous_str}
        ##

        **Previous Purpose**:
        ##
        {previous_purpose}
        ##

        **Previous Student Response Type**:
        ##
        {student_type}
        ##

        **Optional Guidance Strategies**:
        a) **Explain a concept**: Explain a concept or method to the student, but avoid directly providing the answer to the problem.  
        b) **Provide a hint for a strategy**: Guide the student to adopt a method or strategy that pushes them forward in their thinking.  
        c) **Confirm the student's answer**: Affirm the student's correct response and encourage them to continue thinking about the next step.  
        d) **Correct the student's answer**: Gently point out the student's mistake and guide them to reconsider the problem and self-correct.  
        e) **Ask an open-ended question**: Encourage the student to think deeper or ask them to complete the next part of the answer.  
        f) **Ask a closed-ended question**: Test the student's understanding and memory, focusing on specific knowledge points.  
        g) **Simplify the problem**: Break the problem down into a simpler form to help the student focus on the core.  
        h) **Break down the problem**: Split the problem into smaller parts to help the student solve it step by step.  
        i) **Other**.

        **Task**: Based on the above information, choose the guidance strategy and purpose for this round.

        **Notes**:
        1. If the student has multiple missing knowledge points, do not attempt to address all of them at once. Guide the student through multiple rounds of dialogue to solve them gradually.
        2. If the prediction is that the student can solve the step independently, directly ask the question for the "current breakdown step".
        3. Focus on guiding, with explanations as a supplement: Encourage the student to think for themselves by using various strategies (asking questions, simplifying problems, etc.) and help them explore answers through their own reasoning. Provide explanations only when the student is truly stuck.



        Output format:
The strategy number should be output in the content corresponding to the strategy, and the purpose of this round should be output in the purpose, such as inspection, explanation of a certain knowledge point/concept/skill, etc. Do not set multiple purposes. The output should be in the following Markdown code snippet format, including the surrounding tags “```json” and “```”:
        {{"strategy": “the strategy number you selected”, 
        "purpose": “your purpose”}}
            """

        self.strategy_map = {
        "a": "a. Explain a concept: Explain a certain concept or method to the student without directly providing the answer to the question.",
        "b": "b. Suggest a strategy: Guide the student to adopt a certain method or strategy to advance their thinking.",
        "c": "c. Confirm the student's answer: Acknowledge the student's correct answer and encourage them to continue thinking deeply for the next step.",
        "d": "d. Correct the student's answer: Gently point out the student's mistake and guide them to reconsider the problem for self-correction.",
        "e": "e. Ask an open-ended question: Trigger the student's deeper thinking or ask them to complete the next step of the answer.",
        "f": "f. Ask a closed-ended question: Test the student's understanding and memory, focusing on specific knowledge points.",
        "g": "g. Simplify the question: Simplify the problem into a more manageable form to help the student grasp the core idea.",
        "h": "h. Break down the question: Break the problem into smaller parts to help the student solve it step by step.",
        "i": "i. Other."
        }

#教师最终响应生成
        self.teacher_fianl_response = """You are a teacher, currently guiding a student through solving the following problem. The problem has been broken down into multiple steps, and each breakdown step may require several rounds of dialogue to fully solve. You should guide the student step-by-step in solving the "current breakdown step" of the problem according to their understanding.

        **Problem**: 
        ##
        {question}
        ##

        **Current Breakdown Step**:
        ##
        {ques}
        ##

        **Breakdown Step Explanation**:
        ##
        {ans}
        ##

        **Dialogue History**:
        ##
        {history}
        ##

        **Student Understanding Prediction**:
        You predict the student's understanding level of the current breakdown step as:
        {predict}
        “Can solve independently” means the student has mastered the step and can directly answer without further help;
        “Lacks understanding” means the student needs more help and should be guided through the step.

        **Knowledge the student has mastered**:
        {mastered_knowledge}

        **Knowledge the student is missing**:
        {missing_knowledge}

        **Current Goal**:
        Advance the student in solving the current breakdown step. Please respond to the student’s last message (if any), and you should adopt the following strategy and purpose:
        - Strategy: {strategy}
        - Purpose: {purpose}

        **Notes**:
        1. **Focus on the current breakdown step**: If the student asks unrelated questions, briefly explain and redirect them back to the current step.
        2. **Avoid over-interference**: When explaining concepts or offering strategies, avoid giving the final answer to the current step directly. Refrain from excessive hints and encourage the student to think independently.
        3. **Single-question approach**: Each response should ask only one question (if needed), avoiding multiple or compound questions.
        4. **Personalized guidance**: If the student struggles with a specific part, you may say, “It looks like you're having difficulty with...,” to help them identify weak areas, but avoid over-repetition or awkward phrasing.
        5. **Avoid repeating what the student already understands**: Do not teach content the student has already mastered, and avoid giving excessive hints. Focus on the content the student is struggling with.

             
        **Output format**:
        The output should be a Markdown code snippet in the following format, including the front and back markers “```json” and “```”:
        {{ "response": "your response"}} """
        
        
#学生知识状态更新
        self.state_change = """You are a teacher responsible for updating a student's knowledge state based on their responses to individual steps of a question. The original question has been broken down into multiple independent steps. Please update the student's knowledge state tree based on the student's latest response.

        **Task**:
        ##
        {question}
        ##

        **Student's Knowledge State Tree** (use '#' to represent the hierarchy, and the number after each knowledge point represents the mastery level: 0 = not mastered, 1 = mastered):
        {state}

        **Current Sub-Step**:
        ##
        {ques}
        ##

        **Analysis of the Sub-Step**:
        ##
        {ans}
        ##

        **Conversation History**:
        ##
        {history}
        ##

        **Student's Last Response Type**: {response_type}

        **Last Teacher's Teaching Purpose**: {last_teacher_purpose}

        **Operation Steps**:
        1. Analyze the student's latest answer, response type, and the teacher's teaching purpose to determine if any relevant knowledge points need updating:
        - If the student answers correctly, it may indicate that a previously unmastered knowledge point is now mastered.
        - If the student answers incorrectly, it may indicate that a previously mastered knowledge point has not been fully grasped.
        2. Only update the knowledge state that you are confident about. Leave uncertain knowledge points unchanged. If no knowledge points need updating, leave the knowledge state tree unchanged.

        **Output format**:
        The output should be a Markdown code snippet in the following format, including the front and back markers “```json” and “```”:
        Please determine whether an update is required (indicated by yes or no), and then output the knowledge state tree. Keep the original structure of the knowledge state tree, do not add extra spaces or line breaks, and only modify the values (0 or 1) of the relevant knowledge points:
        {{
        "need_updata": "yes/no",
        "state_tree": "Knowledge state hierarchy tree"
        }} """

        self.llm = llm
        # self.llm = ChatTongyi(model='qwen-max')
    
    ################################################第一步,预测学生能否做对以及缺失的知识点
    def forward_student_step_predict(self, questions, steps, states):
        final_prompts = []
        for question, step, state in zip(questions, steps, states): 
            (step_question, step_analysis) = step
            student_steps_predict_prompt = PromptTemplate.from_template(self.student_steps_predict).partial(question=question, step_question=step_question, step_analysis=step_analysis, state=state).format()
            final_prompts.append(student_steps_predict_prompt)
        
        tmp = self.llm.batch(final_prompts)
        responses = extract_json(tmp)
        return responses
    #######################################################第二步,生成策略——ini版本
    def generate_strategy_ini(self, questions, steps, predicts):
        final_prompts = []
        for question, step, predict in zip(questions, steps, predicts): 
            (step_question, step_analysis) = step
            pre = predict[0]['predict']
            missing = predict[0]['missing_knowledge']
            teacher_strategy_predict_prompt = PromptTemplate.from_template(self.teacher_strategy_predict_ini).partial(question=question, ques=step_question, ans=step_analysis, predict = pre, missing_knowledge=missing).format()
            final_prompts.append(teacher_strategy_predict_prompt)
        
        tmp = self.llm.batch(final_prompts)
        responses = extract_json(tmp)
        for res in responses:
            # 使用正则表达式精确匹配策略字母（单独出现的a-i）
            match = re.search(r'\b[a-i]\b', res[0]['strategy'], re.IGNORECASE)
            if match:
                strategy_key = match.group().lower()
                res[0]['strategy'] = self.strategy_map.get(strategy_key, "unkown strategy")
            else:
                res[0]['strategy'] = "unkown strategy"
        return responses
    #######################################################第二步,生成策略——包含历史对话版本
    def generate_strategy(self, questions, steps, predicts, histories, previous_strategy_lists, previous_student_types):
        final_prompts = []
        for question, step, predict, history, previous_strategy_list, previous_student_type in zip(questions, steps, predicts, histories, previous_strategy_lists, previous_student_types): 
            (step_question, step_analysis) = step
            pre = predict[0]['predict']
            missing = predict[0]['missing_knowledge']
            previous_str = previous_strategy_list[0]['strategy']
            previous_purpose = previous_strategy_list[0]['purpose']
            teacher_strategy_predict_prompt = PromptTemplate.from_template(self.teacher_strategy_predict).partial(question=question, ques=step_question, ans=step_analysis, predict = pre, missing_knowledge=missing, previous_str = previous_str, previous_purpose = previous_purpose, history = history, student_type = previous_student_type).format()
            final_prompts.append(teacher_strategy_predict_prompt)
        
        tmp = self.llm.batch(final_prompts)
        responses = extract_json(tmp)
        for res in responses:
            # 使用正则表达式精确匹配策略字母（单独出现的a-i）
            match = re.search(r'\b[a-i]\b', res[0]['strategy'], re.IGNORECASE)
            if match:
                strategy_key = match.group().lower()
                res[0]['strategy'] = self.strategy_map.get(strategy_key, "unkown strategy")
            else:
                res[0]['strategy'] = "unkown strategy"
        return responses
    #######################################################第三步,生成具体响应
    def generate_final_response(self, questions, steps, strategies, histories, predicts):
        final_prompts = []
        for question, step, strategy, history, predict in zip(questions, steps, strategies, histories, predicts): 
            (step_question, step_analysis) = step
            stra = strategy[0]['strategy']
            purpose = strategy[0]['purpose']
            pre = predict[0]['predict']
            missing = predict[0]['missing_knowledge']
            master = predict[0]['mastered_knowledge']
            teacher_fianl_response_prompt = PromptTemplate.from_template(self.teacher_fianl_response).partial(question=question, ques=step_question, ans=step_analysis, strategy=stra, purpose=purpose, history=history, predict = pre, missing_knowledge = missing, mastered_knowledge=master ).format()
            final_prompts.append(teacher_fianl_response_prompt)
        
        tmp = self.llm.batch(final_prompts)
        responses = extract_json(tmp)
        return responses

    def generate_new_state(self, questions, states, steps, histories, response_types, strategies):
        final_prompts = []
        for question, state, step, history, response_type, strategy in zip(questions, states, steps, histories, response_types, strategies):
            (step_question, step_analysis) = step
            last_teacher_purpose = strategy[0]['purpose']
            state_change_prompt = PromptTemplate.from_template(self.state_change).partial(question=question, state=state, ques=step_question, ans=step_analysis, history=history, response_type=response_type, last_teacher_purpose=last_teacher_purpose).format()
            final_prompts.append(state_change_prompt)
        tmp = self.llm.batch(final_prompts)
        state_responses = extract_json(tmp)
        return state_responses

    
    def extract_last_round(self, dialogues):
    # 用来存储每个对话的最后一轮教师和学生的对话
        last_teacher_list = []
        last_student_list = []
        
        # 遍历所有对话
        for dialogue in dialogues:
            # 定义提取教师和学生最后一轮对话的函数
            teacher_dialogues = []
            student_dialogues = []
            
            # 正则表达式匹配教师和学生的对话
            teacher_pattern = r'Teacher:(.*?)\|EOM\|'
            student_pattern = r'Student:(.*?)\|EOM\|'
            
            teacher_dialogues = re.findall(teacher_pattern, dialogue, re.DOTALL)
            student_dialogues = re.findall(student_pattern, dialogue, re.DOTALL)
            
            # 获取教师最后一轮对话
            if teacher_dialogues:
                last_teacher = teacher_dialogues[-1].strip()  # 获取最后一轮教师对话
                if '？' in last_teacher:
                    # 如果包含问号，提取问号前的逗号或者句号后的内容
                    last_teacher = re.split(r'[，。]', last_teacher)[-1].strip()
            else:
                last_teacher = ""
            
            # 获取学生最后一轮对话
            last_student = student_dialogues[-1].strip() if student_dialogues else ""
            
            # 将结果加入到对应的列表
            last_teacher_list.append(last_teacher)
            last_student_list.append(last_student)
        
        return last_teacher_list, last_student_list
    
    def format_sentences(self, sentences):
        formatted_output = []
        for sentence in sentences:
            problem = sentence.get("question", "")
            last_system = sentence.get("last_system", "")
            last_user = sentence.get("last_user", "")
            strategy = sentence.get("teacher_type", "")
            teacher_response = sentence.get("system", "")
            
            formatted_sentence = (
                f"[problem]{problem}[history]Teacher: {last_system}|EOM| Student: {last_user} "
                f"[Strategy]:{strategy} [teacher_response]:{teacher_response}"
            )
            formatted_output.append(formatted_sentence)
        
        return formatted_output

    def do_retreival(self, model, response_type, last_student_list, last_teacher_list, context_embedding, context_source):
        # Combine the three lists element-wise and convert to a tensor
        combined_list = [f"{rt};{ls};{lt}" for rt, ls, lt in zip(response_type, last_student_list, last_teacher_list)]
        combined_tensor = model.encode(combined_list)
        
        # Extract vectors from context_embedding and convert to a NumPy array
        vectors = np.array(list(context_embedding.values()))
        
        # Initialize the FAISS index
        index_retri = faiss.IndexFlatL2(768)
        index_retri.add(vectors)  # Add vectors to the index
        
        # Search for the top 3 nearest neighbors
        _, I = index_retri.search(combined_tensor, 3)
        # .cpu().numpy()
        
        # Retrieve the corresponding sentences from context_source
        retrieved_sentences = []
        for indices in I:
            sentences = []
            for idx in indices:
                # Find the key in context_embedding that corresponds to the index
                key = list(context_embedding.keys())[idx]
                # Retrieve the sentence from context_source using the key as index
                if 0 <= int(key) < len(context_source):
                    sentences.append(context_source[int(key)])
                else:
                    sentences.append("")
            tmp = self.format_sentences(sentences)  # Handle out-of-bounds index
            retrieved_sentences.append(tmp)
        
        return retrieved_sentences

    def forward_2(self, problems, current_steps, predicts, histories, step_pointers, previous_step_pointers, is_first_round=False, strategy=None, purpose=None, response_type=None, model=None, context_embedding=None,context_source=None):
        final_prompts = []
        last_student_list, last_teacher_list = self.extract_last_round(histories)
        ##################编码
        #response_type;last_student_list;last_teacher_list
        if is_first_round:
            retri_instances =  [""] * len(problems)
        else:
            retri_instances = self.do_retreival(model, response_type, last_student_list, last_teacher_list, context_embedding, context_source)

        for problem, current_step, predict, history, step_pointer, previous_step_pointer, retri_instance in zip(problems, current_steps, predicts, histories, step_pointers, previous_step_pointers, retri_instances):
            (ques,ans)=current_step

            if is_first_round or step_pointer != previous_step_pointer:
                teacher_prompt = PromptTemplate.from_template(self.teacher_prompt_ini).partial(problem=problem, ques = ques, ans = ans, predict=predict, history=history).format()

            else:
        
                teacher_prompt = PromptTemplate.from_template(self.teacher_prompt).partial(problem=problem, ques = ques, ans = ans,  predict=predict, history=history, strategy=strategy, purpose=purpose, response_type=response_type, exmple1=retri_instance[0], exmple2=retri_instance[1], exmple3=retri_instance[2]).format()

            final_prompts.append(teacher_prompt)
        teacher_res = self.llm.batch(final_prompts)

        return teacher_res
