#!/bin/bash

# Function to run the command multiple times
run_command() {
    for i in {1..5}; do
        source activate tcmdp
        taskset -c $1 python src/main_m2td3.py --env_name $2 --seed $i --project_name m2td3_oraclerrl --experiment_name $2_$i --device $3 --max_steps=5000000 --nb_uncertainty_dim=3 --output_dir=result --oracle_parameters_agent=True
    done
}

# tmux 1
tmux new-session -d -s tmux_6 "$(typeset -f); run_command '15-17' 'Ant' 'cuda:1'"

# tmux 2
tmux new-session -d -s tmux_7 "$(typeset -f); run_command '18-20' 'HalfCheetah' 'cuda:1'"

# tmux 3
tmux new-session -d -s tmux_8 "$(typeset -f); run_command '21-23' 'Hopper' 'cuda:1'"

# tmux 4
tmux new-session -d -s tmux_9 "$(typeset -f); run_command '24-26' 'HumanoidStandup' 'cuda:1'"

# tmux 5
tmux new-session -d -s tmux_10 "$(typeset -f); run_command '27-29' 'Walker' 'cuda:1'"

echo "All tmux sessions started. Use 'tmux attach-session -t [session_name]' to attach to a session."
