#!/bin/bash

# Check if the seed argument is provided
if [ -z "$1" ]; then
  echo "Usage: $0 <seed>"
  exit 1
fi

# Assign the seed value
SEED=$1

# tmux 1
ENV_NAME="Ant"
EXPERIMENT_NAME="${ENV_NAME}_${SEED}"
tmux new-session -d -s tmux_6 "source activate tcmdp; taskset -c 0-2 python src/main_rarl.py --env_name $ENV_NAME --project_name rarl_oraclerrl --device cuda:0  --max_steps 5_000_000 --nb_uncertainty_dim 3 --oracle_parameters_agent True --output_dir result --seed $SEED --experiment_name $EXPERIMENT_NAME"

# tmux 2
ENV_NAME="HalfCheetah"
EXPERIMENT_NAME="${ENV_NAME}_${SEED}"
tmux new-session -d -s tmux_7 "source activate tcmdp; taskset -c 3-4 python src/main_rarl.py --env_name $ENV_NAME --project_name rarl_oraclerrl --device cuda:0  --max_steps 5_000_000 --nb_uncertainty_dim 3 --oracle_parameters_agent True --output_dir result --seed $SEED --experiment_name $EXPERIMENT_NAME"

# tmux 3
ENV_NAME="Hopper"
EXPERIMENT_NAME="${ENV_NAME}_${SEED}"
tmux new-session -d -s tmux_8 "source activate tcmdp; taskset -c 5-6 python src/main_rarl.py --env_name $ENV_NAME --project_name rarl_oraclerrl --device cuda:0  --max_steps 5_000_000 --nb_uncertainty_dim 3 --oracle_parameters_agent True --output_dir result --seed $SEED --experiment_name $EXPERIMENT_NAME"

# tmux 4
ENV_NAME="HumanoidStandup"
EXPERIMENT_NAME="${ENV_NAME}_${SEED}"
tmux new-session -d -s tmux_9 "source activate tcmdp; taskset -c 7-8 python src/main_rarl.py --env_name $ENV_NAME --project_name rarl_oraclerrl --device cuda:0  --max_steps 5_000_000 --nb_uncertainty_dim 3 --oracle_parameters_agent True --output_dir result --seed $SEED --experiment_name $EXPERIMENT_NAME"

# tmux 5
ENV_NAME="Walker"
EXPERIMENT_NAME="${ENV_NAME}_${SEED}"
tmux new-session -d -s tmux_10 "source activate tcmdp; taskset -c 9-10 python src/main_rarl.py --env_name $ENV_NAME --project_name rarl_oraclerrl --device cuda:0  --max_steps 5_000_000 --nb_uncertainty_dim 3 --oracle_parameters_agent True --output_dir result --seed $SEED --experiment_name $EXPERIMENT_NAME"

echo "All tmux sessions started. Use 'tmux attach-session -t [session_name]' to attach to a session."
