#!/bin/bash
source activate tcmdp
#If not done download the agents from wandb and extract them
python script/extract_wandb_exp.py --entity="anonymous" --project="paper_oracleTCRARL" --download_folder="paper_baselines/oracle_tc-rarl" --handle_missing_seed=True
python script/gather_agents.py --all_logs_folder "paper_baselines" --output_folder "paper_agents"

# Function to run the command multiple times
run_command() {
    source activate tcmdp

    # Loop over each file that matches the pattern in the specified directory
    for agent_file in paper_agents/oracle_tc-rarl/$2/3/agent_*_$2_3.pth; do
        # Extract the agent number from the filename using a Bash parameter expansion
        agent_number=$(basename $agent_file | sed -E "s/agent_([0-9]+)_${2}_3\.pth/\1/")

        # Run the python command with the extracted agent number
        taskset -c $1 python src/main_tc_adversary.py --agent_path $agent_file --env_name $2 --agent_type oracle --project_name paper_adversaryOracleTCRARL --device $3 --radius 0.001 --max_steps 5000000 --nb_uncertainty_dim 3 --experiment_name tc_adv_$2_$agent_number --seed $agent_number --omniscient_adversary True --device $3
    done
}

# tmux 1
tmux new-session -d -s tmux_1 "$(typeset -f); run_command '0-2' 'Ant' 'cuda:1'"

# tmux 2
tmux new-session -d -s tmux_2 "$(typeset -f); run_command '3-5' 'HalfCheetah' 'cuda:1'"

# tmux 3
tmux new-session -d -s tmux_3 "$(typeset -f); run_command '6-8' 'Hopper' 'cuda:1'"

# tmux 4
tmux new-session -d -s tmux_4 "$(typeset -f); run_command '9-11' 'HumanoidStandup' 'cuda:1'"

# tmux 5
tmux new-session -d -s tmux_5 "$(typeset -f); run_command '12-14' 'Walker' 'cuda:1'"

echo "All tmux sessions started. Use 'tmux attach-session -t [session_name]' to attach to a session."
