#!/bin/bash

# Usage: ./download_wandb_projects.sh prefix project_folder

prefix=$1
download_folder=$2

# Ensure prefix and download_folder are provided
if [[ -z "$prefix" ]] || [[ -z "$download_folder" ]]; then
    echo "Usage: $0 <prefix_project_name> <download_folder>"
    exit 1
fi

# Ensure the download folder exists
mkdir -p "$download_folder"

# Activate your Python environment here if needed
# source your_virtualenv/bin/activate

# Get list of projects
projects=$(python script/list_project_wandb.py)

# Loop through the projects and download artifacts if the project name matches the prefix
for project in $projects; do
    echo "Checking project: $project"
    if [[ $project == $prefix* ]]; then
        # Create a directory for the project
        project_folder="$download_folder/${project}"
        mkdir -p "$project_folder"

        # Download artifacts for the project
        echo "Downloading artifacts for project: $project"
        echo "Project folder: $project_folder"
        # python -m pdb -c c script/extract_wandb_exp.py --entity="anonymous" --project="$project" --download_folder="$project_folder"
        python script/extract_wandb_exp.py --entity="anonymous" --project="$project" --download_folder="$project_folder"
    fi
done

echo "Download completed."
