
# Open-Ended Reinforcement Learning with Neural Reward Functions

This folder contains supplementary material and the code of the paper.

## Animations
- robotics_skills.gif: A hand-picked selection of 5 interesting skills per environment.
- robotics_one_leg.gif and robotics_getting_faster.gif : Two sequences of consecutive skills (one skills was removed in robotics_one_leg.gif as the agent died often)
- montezuma_skill_29_Figure6.gif : The skill that is depicted in Figure 6 in Section 4 of the paper.
- montezuma_exploring_other_rooms.gif : A skill that involves visiting four rooms.


## Code

**Warning: This is not the final version of the code and it will be refactored before public release**

Each folder contains the code for a set of experiments from Section 4. They are named according to the environment.  

### 2d navigation

How to run: "python3 main.py {experiment_name}" where {experiment_name} is the folder that will be used to store the experiment results.


### robotic environments.
How to run:  "python3 run_experiment.py {gpu_id}" where {gpu_id} is a single gpu id to tell CUDA which device to use. 

### Montezumas Revenge
How to run: "python3 main.py"



