import re
import html
from bs4 import BeautifulSoup


class HTMLProcessor:

    def __init__(self):
        self.use_bs4 = True

    def clean_html(self, text: str) -> str:
         
        if not text:
            return ""

                                     
        text = self._process_markdown_links(text)

                  
        text = self._clean_html_with_bs4(text)

                       
        text = self._post_process_text(text)

        return text

    def _process_markdown_links(self, text: str) -> str:
                                         
                           
        def replace_link(match):
            link_text = match.group(1)
                                  
                                  
            return f"{link_text}"

              
        text = re.sub(r'\[([^\]]+)\]\(([^)]+)\)', replace_link, text)
        return text

    def _clean_html_with_bs4(self, text: str) -> str:
                                   
        try:
                    
            soup = BeautifulSoup(text, 'html.parser')

                              
            for script in soup(["script", "style"]):
                script.decompose()

                               
            for table in soup.find_all('table'):
                self._process_table(table)

                  
            for ul in soup.find_all(['ul', 'ol']):
                self._process_list(ul)

                   
            text = soup.get_text()

                      
            text = html.unescape(text)

            return text

        except Exception as e:
            return text

    def _process_table(self, table):
                                  
                   
        for tr in table.find_all('tr'):
            tr.append('\n')

                     
        for td in table.find_all(['td', 'th']):
            if td.string:
                td.string.replace_with(f" {td.string} ")

    def _process_list(self, list_element):
                              
        for li in list_element.find_all('li'):
            if li.string:
                li.string.replace_with(f"• {li.string}\n")

    def _post_process_text(self, text: str) -> str:
                             
                                 
        text = re.sub(r'\[[0-9]+\]', '', text)

                 
        text = re.sub(r'\n\s*\n\s*\n', '\n\n', text)

                  
        lines = [line.strip() for line in text.split('\n')]
        text = '\n'.join(lines)

                 
        text = re.sub(r' +', ' ', text)

                
        text = text.strip()

        return text
