from typing import Optional
from dataclasses import dataclass


@dataclass
class RAGConfig:
                              
          
    game_name: str = "dyinglight2"
    target_segment_id: Optional[int] = None
    include_timeless: bool = True

          
    corpus_dir: str = "../data"
    qa_data_dir: str = "../generation/data"
    index_dir: str = "./index"

            
    retrieval_results_dir: str = "./retrieval_results"
    generation_results_dir: str = "./generation_results"

           
    api_key: str = "{your api_key}"
    base_url: str = "{your base_url}"

          
    embedding_model: str = "text-embedding-3-small"
    top_k: int = 3

          
    llm_model: str = "gpt-4o"
    temperature: float = 0.7

          
    force_rebuild: bool = False
    verbose: bool = True


@dataclass
class RetrievalConfig:
                  
          
    game_name: str = "dyinglight2"
    target_segment_id: Optional[int] = None
    data_type: str = "resample"                                                                                  
    include_timeless: bool = True

          
    corpus_dir: str = "../data"
    qa_data_dir: str = "../generation/data"
    index_dir: str = "./index"
    output_dir: str = "./retrieval_results"

                        
    api_key: str = "{your api_key}"
    base_url: str = "{your base_url}"

                       
    siliconflow_api_key: str = "{your api_key}"
    siliconflow_base_url: str = "{your base_url}"

          
    retrieval_method: str = "vector"                     
    embedding_model: str = "text-embedding-3-small"
    embedding_service: str = "openai"                            
    top_k: int = 3

            
    bm25_k1: float = 1.2
    bm25_b: float = 0.75

          
    force_rebuild: bool = False
    verbose: bool = True

    @classmethod
    def from_rag_config(cls, rag_config: RAGConfig) -> 'RetrievalConfig':
                                         
        return cls(
            game_name=rag_config.game_name,
            target_segment_id=rag_config.target_segment_id,
            include_timeless=rag_config.include_timeless,
            corpus_dir=rag_config.corpus_dir,
            qa_data_dir=rag_config.qa_data_dir,
            index_dir=rag_config.index_dir,
            output_dir=rag_config.retrieval_results_dir,
            api_key=rag_config.api_key,
            base_url=rag_config.base_url,
            embedding_model=rag_config.embedding_model,
            top_k=rag_config.top_k,
            force_rebuild=rag_config.force_rebuild,
            verbose=rag_config.verbose
        )


@dataclass
class GenerationConfig:
                  
           
    api_key: str = "{your api_key}"
    base_url: str = "{your base_url}"

          
    llm_model: str = "gpt-4o"
    temperature: float = 0.7

          
    output_dir: str = "./generation_results"

          
    concurrent_requests: int = 3

          
    verbose: bool = True

    @classmethod
    def from_rag_config(cls, rag_config: RAGConfig) -> 'GenerationConfig':
                                          
        return cls(
            api_key=rag_config.api_key,
            base_url=rag_config.base_url,
            llm_model=rag_config.llm_model,
            temperature=rag_config.temperature,
            output_dir=rag_config.generation_results_dir,
            verbose=rag_config.verbose
        )
