task_description = {
    "Extraction-based QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to answer single-hop questions. That is, user questions do not require complex reasoning, and the answers can be directly found and extracted from retrieved game documents (such as official news, guides, setting collections, game manuals, game forums, etc.).
        - Please note the distinction between this task and multi-hop reasoning questions. Answers should be obtainable through a single information point. Examples include: skill descriptions of a character, trigger conditions of a quest, acquisition methods of an item, etc.""",
    "Multi-hop Reasoning QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to answer questions that require multi-step logical reasoning. That is, answers cannot be directly obtained from a single document, and the model needs to combine multiple information points and perform **at least two-hop reasoning** to arrive at the final answer.
        - It is strictly prohibited to generate questions that can be answered directly with single-hop information.
        - The generation of multi-hop reasoning QA data mainly includes the following two categories:
            1. Construct "entity-relationship" chains containing progressive information relationships (e.g., character → faction → faction's special abilities → ability's counter targets), and generate multi-hop reasoning questions based on these chains. Questions should contain at least two unknown information points, and intermediate information is necessary for the final answer.
               Example: To answer "Does character A have an advantage when fighting character B in PvP?", one needs to first obtain character A's skill mechanics, then character B's weaknesses, and finally reason about whether there is a counter relationship.
            2. Construct questions that require game mechanism calculations based on information provided in documents, such as calculating actual damage output based on equipment attributes, skill multipliers, and enemy resistances. Please ensure that generated questions and answers have logical consistency and accuracy.
        - If only referencing one document, please generate the second type of reasoning questions (mechanism calculation type).
        - If referencing multiple documents, please generate the first type of reasoning questions (information chain type), and ensure that generated questions require synthesizing information from all documents, not relying solely on single document content.
        - Note: Do not directly write intermediate reasoning steps or answers in the question, otherwise the question will degenerate into a single-hop question.""",
    "Comparative QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to handle comparative questions. That is, questions require comparing differences and advantages/disadvantages between two or more game characters, items, levels, systems, etc.
        - Answers should provide accurate and comprehensive comparative analysis.
        - When I provide multiple document data, please ensure that generated question-answer data is cross-document, meaning answering the question requires synthesizing all document content. Relying only on partial documents will result in incomplete answers.
        - Example questions: Compare the roles and functions of two classes in team dungeons; Analyze differences in changes to the same character across two version updates, etc.""",
    "Long-form Answer QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to generate rich, well-structured long answers, suitable for introductory and summary questions.
        - Answers should cover all aspects involved in the question, with comprehensive information and clear organization.
        - When I provide multiple document data, please ensure that generated question-answer data is cross-document, meaning answering the question requires integrating all document content. Basing answers only on partial documents will result in incomplete answers.
        - Example questions: Introduce the setting of a game's world view; Summarize skill changes of a character across multiple versions; Analyze the functions and gameplay of a game system, etc."""
}

task_description_old = {
    "Extraction-based QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to answer single-hop questions. That is, user questions do not require complex reasoning, and the answers can be directly found and extracted from retrieved game documents (such as official news, guides, setting collections, game manuals, game forums, etc.).
        - Please note the distinction between this task and multi-hop reasoning questions. Answers should be obtainable through a single information point. Examples include: skill descriptions of a character, trigger conditions of a quest, acquisition methods of an item, etc.""",
    "Multi-hop Reasoning QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to answer questions that require multi-step logical reasoning. That is, answers cannot be directly obtained from a single document, and the model needs to combine multiple information points and perform **at least two-hop reasoning** to arrive at the final answer.
        - It is strictly prohibited to generate questions that can be answered directly with single-hop information.
        - The generation of multi-hop reasoning QA data mainly includes the following two categories:
            1. Construct "entity-relationship" chains containing progressive information relationships (e.g., character → faction → faction's special abilities → ability's counter targets), and generate multi-hop reasoning questions based on these chains. Questions should contain at least two unknown information points, and intermediate information is necessary for the final answer.
               Example: To answer "Does character A have an advantage when fighting character B in PvP?", one needs to first obtain character A's skill mechanics, then character B's weaknesses, and finally reason about whether there is a counter relationship.
            2. Construct questions that require game mechanism calculations based on information provided in documents, such as calculating actual damage output based on equipment attributes, skill multipliers, and enemy resistances. Please ensure that generated questions and answers have logical consistency and accuracy.
        - If only referencing one document, please generate the second type of reasoning questions (mechanism calculation type).
        - If referencing multiple documents, please generate the first type of reasoning questions (information chain type), and ensure that generated questions require synthesizing information from all documents, not relying solely on single document content.
        - Note: Do not directly write intermediate reasoning steps or answers in the question, otherwise the question will degenerate into a single-hop question.""",
    "Comparative QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to handle comparative questions. That is, questions require comparing differences and advantages/disadvantages between two or more game characters, items, levels, systems, etc.
        - Answers should provide accurate and comprehensive comparative analysis.
        - When I provide multiple document data, please ensure that generated question-answer data is cross-document, meaning answering the question requires synthesizing all document content. Relying only on partial documents will result in incomplete answers.
        - Example questions: Compare the roles and functions of two classes in team dungeons; Analyze differences in changes to the same character across two version updates, etc.""",
    "Long-form Answer QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to generate rich, well-structured long answers, suitable for introductory and summary questions.
        - Answers should cover all aspects involved in the question, with comprehensive information and clear organization.
        - When I provide multiple document data, please ensure that generated question-answer data is cross-document, meaning answering the question requires integrating all document content. Basing answers only on partial documents will result in incomplete answers.
        - Example questions: Introduce the setting of a game's world view; Summarize skill changes of a character across multiple versions; Analyze the functions and gameplay of a game system, etc.""",
    "Time-sensitive QA": """### Task Requirements
        - This task aims to evaluate the ability of retrieval-augmented game large language models to answer time-sensitive questions. That is, questions involve time-related information such as game version updates, event schedules, season cycles, etc.
        - Questions should specify concrete game versions or time points, such as: "skill changes of a character in the current version", "adjustments to a system in the latest version update", "schedule of an event", etc.
        - Answers should accurately reflect the game state at the current time point or specified time point.
        - Example questions: Skill changes of a character in version V1.1; Adjustments to a system in the version update on February 1, 2024, etc."""
}

task_list = list(task_description.keys())
