import os
import json
import requests

from tqdm import tqdm as tqdm
from datasets import load_dataset
from constants import * 


def download_json(url, filename):
    # print(url)
    response = requests.get(url)

    if response.status_code == 200:
        os.makedirs(os.path.dirname(filename), exist_ok=True)
        data = response.json()

        with open(filename, "w") as file:
            json.dump(data, file, indent=4)

        # print("Download complete. File saved as:", filename)
        return True
    else:
        # print("Failed to retrieve data. Status code:", response.status_code)
        return False

def load_data():

    dataset = load_dataset("lmsys/mt_bench_human_judgments")
    dataset["human"].to_json("human_judgments.json")
    dataset["gpt4_pair"].to_json("gpt4_pair_judgments.json")

    os.makedirs(dir_predictions, exist_ok=True)
    for model_name in model_list:
        for i, line in enumerate(meta_predictions.split("\n")):
            file_name = line.strip().replace("openai_gpt-4o-2024-05-13", model_name)

            path_save = os.path.join(
                os.path.join(dir_predictions, file_name), "instances.json"
            )
            if not os.path.exists(path_save):
                found = False
                for version in range(6):
                    url = (
                            "https://storage.googleapis.com/crfm-helm-public/mmlu/benchmark_output/runs/v1.%d.0/%s/instances.json"
                            % (version, file_name)
                    )
                    if download_json(url, path_save):
                        found = True
                        break
                if not found:
                    print("Not Found:", url)

            path_save = os.path.join(
                os.path.join(dir_predictions, file_name), "display_predictions.json"
            )
            if not os.path.exists(path_save):
                found = False
                for version in range(6):
                    url = (
                            "https://storage.googleapis.com/crfm-helm-public/mmlu/benchmark_output/runs/v1.%d.0/%s/display_predictions.json"
                            % (version, file_name)
                    )
                    if download_json(url, path_save):
                        found = True
                        break
                if not found:
                    print("Not Found:", url)

            path_save = os.path.join(
                os.path.join(dir_predictions, file_name), "display_requests.json"
            )
            if not os.path.exists(path_save):
                found = False
                for version in range(6):
                    url = (
                            "https://storage.googleapis.com/crfm-helm-public/mmlu/benchmark_output/runs/v1.%d.0/%s/display_requests.json"
                            % (version, file_name)
                    )
                    if download_json(url, path_save):
                        found = True
                        break
                if not found:
                    print("Not Found:", url)
                    
if __name__ == "__main__":
    load_data()