import os
import json

from tqdm import tqdm

import torch


src_mask_paths = [
    'PATH_TO_NEURON_MASK_1',
    'PATH_TO_NEURON_MASK_2'
]

tgt_folder = "PATH_TO_TARGET_NEURON_MASK"
if (os.path.exists(tgt_folder) == False):
    os.mkdir(tgt_folder)
tgt_mask_path = os.path.join(tgt_folder, 'lper0_rper5.bin')


with torch.no_grad():
    tgt_mask = {}
    for src_mask_path in src_mask_paths:
        src_mask = torch.load(src_mask_path)
        for nam, param in tqdm(src_mask.items()):
            if (nam not in tgt_mask):
                tgt_mask[nam] = param
            else:
                tmp_param = tgt_mask[nam] + param
                tgt_mask[nam] = torch.where(tmp_param > 0, 1.0, 0.0)
    torch.save(tgt_mask, tgt_mask_path)