JOB_NAME=JOB_NAME
DATA_PATH=DATA_PATH
OUTPUT_DIR=OUTPUT_DIR
LOG_PATH=LOG_PATH

mkdir ${LOG_PATH}

NNODES=1
NODE_RANK=0
MASTER_ADDR=MASTER_ADDR
MASTER_PORT=MASTER_PORT

torchrun \
    --nproc_per_node=8 \
    --nnodes=$NNODES \
    --node_rank=$NODE_RANK \
    --master_addr=$MASTER_ADDR \
    --master_port=$MASTER_PORT \
    pretrain.py \
    --model_name_or_path PATH_TO_BACKBONE_MODEL  \
    --data_path ${DATA_PATH}  \
    --bf16 True \
    --output_dir ${OUTPUT_DIR}/${JOB_NAME} \
    --per_device_train_batch_size 8 \
    --per_device_eval_batch_size 8 \
    --gradient_accumulation_steps 8 \
    --model_max_length 2048 \
    --max_steps 2000 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 1000 \
    --save_total_limit 10 \
    --learning_rate 5e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --gradient_checkpointing True \
    --tf32 True \
    --report_to none \
    --deepspeed ds_z3_bf16.json \
    --language ${LANG} \
&> ${LOG_PATH}/part_${NODE_RANK}.log 
