## 基准和模型库

- [Rotated RetinaNet-OBB/HBB](https://github.com/open-mmlab/mmrotate/tree/main/configs/rotated_retinanet/README.md) (
  ICCV'2017)
- [Rotated FasterRCNN-OBB](https://github.com/open-mmlab/mmrotate/tree/main/configs/rotated_faster_rcnn/README.md) (
  TPAMI'2017)
- [Rotated RepPoints-OBB](https://github.com/open-mmlab/mmrotate/tree/main/configs/rotated_reppoints/README.md) (
  ICCV'2019)
- [Rotated FCOS](https://github.com/open-mmlab/mmrotate/tree/main/configs/rotated_fcos/README.md) (ICCV'2019)
- [RoI Transformer](https://github.com/open-mmlab/mmrotate/tree/main/configs/roi_trans/README.md) (CVPR'2019)
- [Gliding Vertex](https://github.com/open-mmlab/mmrotate/tree/main/configs/gliding_vertex/README.md) (TPAMI'2020)
- [Rotated ATSS-OBB](https://github.com/open-mmlab/mmrotate/tree/main/configs/rotated_atss/README.md) (CVPR'2020)
- [CSL](https://github.com/open-mmlab/mmrotate/tree/main/configs/csl/README.md) (ECCV'2020)
- [R<sup>3</sup>Det](https://github.com/open-mmlab/mmrotate/tree/main/configs/r3det/README.md) (AAAI'2021)
- [S<sup>2</sup>A-Net](https://github.com/open-mmlab/mmrotate/tree/main/configs/s2anet/README.md) (TGRS'2021)
- [ReDet](https://github.com/open-mmlab/mmrotate/tree/main/configs/redet/README.md) (CVPR'2021)
- [Beyond Bounding-Box](https://github.com/open-mmlab/mmrotate/tree/main/configs/cfa/README.md) (CVPR'2021)
- [Oriented R-CNN](https://github.com/open-mmlab/mmrotate/tree/main/configs/oriented_rcnn/README.md) (ICCV'2021)
- [GWD](https://github.com/open-mmlab/mmrotate/tree/main/configs/gwd/README.md) (ICML'2021)
- [KLD](https://github.com/open-mmlab/mmrotate/tree/main/configs/kld/README.md) (NeurIPS'2021)
- [SASM](configs/sasm_reppoints/README.md) (AAAI'2022)
- [KFIoU](https://github.com/open-mmlab/mmrotate/tree/main/configs/kfiou/README.md) (arXiv)
- [G-Rep](https://github.com/open-mmlab/mmrotate/tree/main/configs/g_reppoints/README.md) (stay tuned)

### DOTA v1.0 数据集上的结果

|            骨干网络            |  mAP  | 角度编码方式 | 训练策略 | 显存占用 (GB) | 推理时间 (fps) | 增强方法  | 批量大小 |                                                                        配置                                                                         |                                                                                                                                                                                                           下载                                                                                                                                                                                                           |
|:--------------------------:|:-----:|:------:|:----:|:---------:|:----------:|:-----:|:----:|:-------------------------------------------------------------------------------------------------------------------------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
|  ResNet50 (1024,1024,200)  | 59.44 |   oc   |  1x  |   3.45    |    15.6    |   -   |  2   |                  [rotated_reppoints_r50_fpn_1x_dota_oc](../../configs/rotated_reppoints/rotated_reppoints_r50_fpn_1x_dota_oc.py)                  |                                   [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_reppoints/rotated_reppoints_r50_fpn_1x_dota_oc/rotated_reppoints_r50_fpn_1x_dota_oc-d38ce217.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_reppoints/rotated_reppoints_r50_fpn_1x_dota_oc/rotated_reppoints_r50_fpn_1x_dota_oc_20220205_145010.log.json)                                   |
|  ResNet50 (1024,1024,200)  | 64.55 |   oc   |  1x  |   3.38    |    15.7    |   -   |  2   |              [rotated_retinanet_hbb_r50_fpn_1x_dota_oc](../../configs/rotated_retinanet/rotated_retinanet_hbb_r50_fpn_1x_dota_oc.py)              |                           [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_hbb_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_r50_fpn_1x_dota_oc-e8a7c7df.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_hbb_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_r50_fpn_1x_dota_oc_20220121_095315.log.json)                           |
|  ResNet50 (1024,1024,200)  | 65.59 |   oc   |  1x  |   3.12    |    18.5    |   -   |  2   |                     [rotated_atss_hbb_r50_fpn_1x_dota_oc](../../configs/rotated_atss/rotated_atss_hbb_r50_fpn_1x_dota_oc.py)                      |                                          [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_atss/rotated_atss_hbb_r50_fpn_1x_dota_oc/rotated_atss_hbb_r50_fpn_1x_dota_oc-eaa94033.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_atss/rotated_atss_hbb_r50_fpn_1x_dota_oc/rotated_atss_hbb_r50_fpn_1x_dota_oc_20220402_002230.log.json)                                          |
|  ResNet50 (1024,1024,200)  | 66.45 |   oc   |  1x  |   3.53    |    15.3    |   -   |  2   |                           [sasm_reppoints_r50_fpn_1x_dota_oc](../../configs/sasm/sasm_reppoints_r50_fpn_1x_dota_oc.py)                            |                                                      [model](https://download.openmmlab.com/mmrotate/v0.1.0/sasm/sasm_reppoints_r50_fpn_1x_dota_oc/sasm_reppoints_r50_fpn_1x_dota_oc-6d9edded.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/sasm/sasm_reppoints_r50_fpn_1x_dota_oc/sasm_reppoints_r50_fpn_1x_dota_oc_20220205_144938.log.json)                                                      |
|  ResNet50 (1024,1024,200)  | 68.42 |  le90  |  1x  |   3.38    |    16.9    |   -   |  2   |            [rotated_retinanet_obb_r50_fpn_1x_dota_le90](../../configs/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_le90.py)            |                       [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_le90/rotated_retinanet_obb_r50_fpn_1x_dota_le90-c0097bc4.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_le90/rotated_retinanet_obb_r50_fpn_1x_dota_le90_20220128_130740.log.json)                       |
|  ResNet50 (1024,1024,200)  | 68.79 |  le90  |  1x  |   2.36    |    22.4    |   -   |  2   |                [rotated_retinanet_obb_r50_fpn_fp16_1x_dota_le90](../../configs/rotated_retinanet_obb_r50_fpn_fp16_1x_dota_le90.py)                |             [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_fp16_1x_dota_le90/rotated_retinanet_obb_r50_fpn_fp16_1x_dota_le90-01de71b5.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_fp16_1x_dota_le90/rotated_retinanet_obb_r50_fpn_fp16_1x_dota_le90_20220303_183714.log.json)             |
|  ResNet50 (1024,1024,200)  | 69.49 | le135  |  1x  |   4.05    |    8.6     |   -   |  2   |                        [g_reppoints_r50_fpn_1x_dota_le135](../../configs/g_reppoints/g_reppoints_r50_fpn_1x_dota_le135.py)                        |                                               [model](https://download.openmmlab.com/mmrotate/v0.1.0/g_reppoints/g_reppoints_r50_fpn_1x_dota_le135/g_reppoints_r50_fpn_1x_dota_le135-b840eed7.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/g_reppoints/g_reppoints_r50_fpn_1x_dota_le135/g_reppoints_r50_fpn_1x_dota_le135_20220202_233631.log.json)                                               |
|  ResNet50 (1024,1024,200)  | 69.51 |  le90  |  1x  |   4.40    |    24.0    |   -   |  2   | [rotated_retinanet_obb_csl_gaussian_r50_fpn_fp16_1x_dota_le90](../../configs/csl/rotated_retinanet_obb_csl_gaussian_r50_fpn_fp16_1x_dota_le90.py) | [model](https://download.openmmlab.com/mmrotate/v0.1.0/csl/rotated_retinanet_obb_csl_gaussian_r50_fpn_fp16_1x_dota_le90/rotated_retinanet_obb_csl_gaussian_r50_fpn_fp16_1x_dota_le90-b4271aed.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/csl/rotated_retinanet_obb_csl_gaussian_r50_fpn_fp16_1x_dota_le90/rotated_retinanet_obb_csl_gaussian_r50_fpn_fp16_1x_dota_le90_20220321_010033.log.json) |
|  ResNet50 (1024,1024,200)  | 69.55 |   oc   |  1x  |   3.39    |    15.5    |   -   |  2   |                 [rotated_retinanet_hbb_gwd_r50_fpn_1x_dota_oc](../../configs/gwd/rotated_retinanet_hbb_gwd_r50_fpn_1x_dota_oc.py)                 |                                 [model](https://download.openmmlab.com/mmrotate/v0.1.0/gwd/rotated_retinanet_hbb_gwd_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_gwd_r50_fpn_1x_dota_oc-41fd7805.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/gwd/rotated_retinanet_hbb_gwd_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_gwd_r50_fpn_1x_dota_oc_20220120_152421.log.json)                                 |
|  ResNet50 (1024,1024,200)  | 69.60 |  le90  |  1x  |   3.38    |    15.1    |   -   |  2   |            [rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le90](../../configs/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le90.py)            |                       [model](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le90/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le90-03e02f75.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le90/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le90_20220209_173225.log.json)                       |
|  ResNet50 (1024,1024,200)  | 69.63 | le135  |  1x  |   3.45    |    16.1    |   -   |  2   |                                    [cfa_r50_fpn_1x_dota_le135](../../configs/cfa/cfa_r50_fpn_1x_dota_le135.py)                                    |                                                                       [model](https://download.openmmlab.com/mmrotate/v0.1.0/cfa/cfa_r50_fpn_1x_dota_le135/cfa_r50_fpn_1x_dota_le135-aed1cbc6.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/cfa/cfa_r50_fpn_1x_dota_le135/cfa_r50_fpn_1x_dota_le135_20220205_144859.log.json)                                                                       |
|  ResNet50 (1024,1024,200)  | 69.76 |   oc   |  1x  |   3.39    |    15.6    |   -   |  2   |              [rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_oc](../../configs/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_oc.py)              |                           [model](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_oc-c00be030.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_oc_20220126_081643.log.json)                           |
|  ResNet50 (1024,1024,200)  | 69.77 | le135  |  1x  |   3.38    |    15.3    |   -   |  2   |           [rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le135](../../configs/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le135.py)           |                     [model](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le135/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le135-0eaa4156.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le135/rotated_retinanet_hbb_kfiou_r50_fpn_1x_dota_le135_20220209_173257.log.json)                     |
|  ResNet50 (1024,1024,200)  | 69.79 | le135  |  1x  |   3.38    |    17.2    |   -   |  2   |           [rotated_retinanet_obb_r50_fpn_1x_dota_le135](../../configs/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_le135.py)           |                     [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_le135/rotated_retinanet_obb_r50_fpn_1x_dota_le135-e4131166.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_le135/rotated_retinanet_obb_r50_fpn_1x_dota_le135_20220128_130755.log.json)                     |
|  ResNet50 (1024,1024,200)  | 69.80 |   oc   |  1x  |   3.54    |    12.4    |   -   |  2   |                                    [r3det_r50_fpn_1x_dota_oc](../../configs/r3det/r3det_r50_fpn_1x_dota_oc.py)                                    |                                                                       [model](https://download.openmmlab.com/mmrotate/v0.1.0/r3det/r3det_r50_fpn_1x_dota_oc/r3det_r50_fpn_1x_dota_oc-b1fb045c.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/r3det/r3det_r50_fpn_1x_dota_oc/r3det_r50_fpn_1x_dota_oc_20220126_191226.log.json)                                                                       |
|  ResNet50 (1024,1024,200)  | 69.94 |   oc   |  1x  |   3.39    |    15.6    |   -   |  2   |                 [rotated_retinanet_hbb_kld_r50_fpn_1x_dota_oc](../../configs/kld/rotated_retinanet_hbb_kld_r50_fpn_1x_dota_oc.py)                 |                                 [model](https://download.openmmlab.com/mmrotate/v0.1.0/kld/rotated_retinanet_hbb_kld_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_kld_r50_fpn_1x_dota_oc-49c1f937.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/kld/rotated_retinanet_hbb_kld_r50_fpn_1x_dota_oc/rotated_retinanet_hbb_kld_r50_fpn_1x_dota_oc_20220125_201832.log.json)                                 |
|  ResNet50 (1024,1024,200)  | 70.18 |   oc   |  1x  |   3.23    |    15.6    |   -   |  2   |                               [r3det_tiny_r50_fpn_1x_dota_oc](../../configs/r3det/r3det_tiny_r50_fpn_1x_dota_oc.py)                               |                                                             [model](https://download.openmmlab.com/mmrotate/v0.1.0/r3det/r3det_tiny_r50_fpn_1x_dota_oc/r3det_tiny_r50_fpn_1x_dota_oc-c98a616c.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/r3det/r3det_tiny_r50_fpn_1x_dota_oc/r3det_tiny_r50_fpn_1x_dota_oc_20220209_171624.log.json)                                                             |
|  ResNet50 (1024,1024,200)  | 70.64 |  le90  |  1x  |   3.12    |    18.2    |   -   |  2   |                   [rotated_atss_obb_r50_fpn_1x_dota_le90](../../configs/rotated_atss/rotated_atss_obb_r50_fpn_1x_dota_le90.py)                    |                                      [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_atss/rotated_atss_obb_r50_fpn_1x_dota_le90/rotated_atss_obb_r50_fpn_1x_dota_le90-e029ca06.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_atss/rotated_atss_obb_r50_fpn_1x_dota_le90/rotated_atss_obb_r50_fpn_1x_dota_le90_20220402_002048.log.json)                                      |
|  ResNet50 (1024,1024,200)  | 70.70 |  le90  |  1x  |   4.18    |            |   -   |  2   |             [rotated_fcos_sep_angle_r50_fpn_1x_dota_le90](../../configs/rotated_fcos/rotated_fcos_sep_angle_r50_fpn_1x_dota_le90.py)              |                                                                                                                                                                                               [model](-) &#124; [log](-)                                                                                                                                                                                               |
|  ResNet50 (1024,1024,200)  | 71.28 |  le90  |  1x  |   4.18    |            |   -   |  2   |                       [rotated_fcos_r50_fpn_1x_dota_le90](../../configs/rotated_fcos/rotated_fcos_r50_fpn_1x_dota_le90.py)                        |                                                                                                                                                                                               [model](-) &#124; [log](-)                                                                                                                                                                                               |
|  ResNet50 (1024,1024,200)  | 71.76 |  le90  |  1x  |   4.23    |            |   -   |  2   |          [rotated_fcos_csl_gaussian_r50_fpn_1x_dota_le90](../../configs/rotated_fcos/rotated_fcos_csl_gaussian_r50_fpn_1x_dota_le90.py)           |                                                                                                                                                                                               [model](-) &#124; [log](-)                                                                                                                                                                                               |
|  ResNet50 (1024,1024,200)  | 71.83 |   oc   |  1x  |   3.54    |    12.4    |   -   |  2   |                                 [r3det_kld_r50_fpn_1x_dota_oc](../../configs/kld/r3det_kld_r50_fpn_1x_dota_oc.py)                                 |                                                                 [model](https://download.openmmlab.com/mmrotate/v0.1.0/kld/r3det_kld_r50_fpn_1x_dota_oc/r3det_kld_r50_fpn_1x_dota_oc-31866226.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/kld/r3det_kld_r50_fpn_1x_dota_oc/r3det_kld_r50_fpn_1x_dota_oc_20220210_114049.log.json)                                                                 |
|  ResNet50 (1024,1024,200)  | 71.89 |  le90  |  1x  |   4.18    |            |   -   |  2   |                   [rotated_fcos_kld_r50_fpn_1x_dota_le90](../../configs/rotated_fcos/rotated_fcos_kld_r50_fpn_1x_dota_le90.py)                    |                                                                                                                                                                                               [model](-) &#124; [log](-)                                                                                                                                                                                               |
|  ResNet50 (1024,1024,200)  | 72.29 | le135  |  1x  |   3.19    |    18.8    |   -   |  2   |                  [rotated_atss_obb_r50_fpn_1x_dota_le135](../../configs/rotated_atss/rotated_atss_obb_r50_fpn_1x_dota_le135.py)                   |                                    [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_atss/rotated_atss_obb_r50_fpn_1x_dota_le135/rotated_atss_obb_r50_fpn_1x_dota_le135-eab7bc12.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_atss/rotated_atss_obb_r50_fpn_1x_dota_le135/rotated_atss_obb_r50_fpn_1x_dota_le135_20220402_002138.log.json)                                    |
|  ResNet50 (1024,1024,200)  | 72.68 |   oc   |  1x  |   3.62    |    12.2    |   -   |  2   |                           [r3det_kfiou_ln_r50_fpn_1x_dota_oc](../../configs/kfiou/r3det_kfiou_ln_r50_fpn_1x_dota_oc.py)                           |                                                     [model](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/r3det_kfiou_ln_r50_fpn_1x_dota_oc/r3det_kfiou_ln_r50_fpn_1x_dota_oc-8e7f049d.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/kfiou/r3det_kfiou_ln_r50_fpn_1x_dota_oc/r3det_kfiou_ln_r50_fpn_1x_dota_oc_20220123_074507.log.json)                                                     |
|  ResNet50 (1024,1024,200)  | 72.76 |   oc   |  1x  |   3.44    |    14.0    |   -   |  2   |                            [r3det_tiny_kld_r50_fpn_1x_dota_oc](../../configs/kld/r3det_tiny_kld_r50_fpn_1x_dota_oc.py)                            |                                                       [model](https://download.openmmlab.com/mmrotate/v0.1.0/kld/r3det_tiny_kld_r50_fpn_1x_dota_oc/r3det_tiny_kld_r50_fpn_1x_dota_oc-589e142a.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/kld/r3det_tiny_kld_r50_fpn_1x_dota_oc/r3det_tiny_kld_r50_fpn_1x_dota_oc_20220209_172917.log.json)                                                       |
|  ResNet50 (1024,1024,200)  | 73.23 |  le90  |  1x  |   8.45    |    16.4    |   -   |  2   |                    [gliding_vertex_r50_fpn_1x_dota_le90](../../configs/gliding_vertex/gliding_vertex_r50_fpn_1x_dota_le90.py)                     |                                        [model](https://download.openmmlab.com/mmrotate/v0.1.0/gliding_vertex/gliding_vertex_r50_fpn_1x_dota_le90/gliding_vertex_r50_fpn_1x_dota_le90-12e7423c.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/gliding_vertex/gliding_vertex_r50_fpn_1x_dota_le90/gliding_vertex_r50_fpn_1x_dota_le90_20220129_085529.log.json)                                        |
|  ResNet50 (1024,1024,200)  | 73.40 |  le90  |  1x  |   8.46    |    16.5    |   -   |  2   |             [rotated_faster_rcnn_r50_fpn_1x_dota_le90](../../configs/rotated_faster_rcnn/rotated_faster_rcnn_r50_fpn_1x_dota_le90.py)             |                         [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_faster_rcnn/rotated_faster_rcnn_r50_fpn_1x_dota_le90/rotated_faster_rcnn_r50_fpn_1x_dota_le90-0393aa5c.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_faster_rcnn/rotated_faster_rcnn_r50_fpn_1x_dota_le90/rotated_faster_rcnn_r50_fpn_1x_dota_le90_20220131_082156.log.json)                         |
|  ResNet50 (1024,1024,200)  | 73.45 |   oc   | 40e  |   3.45    |    16.1    |   -   |  2   |                                      [cfa_r50_fpn_40e_dota_oc](../../configs/cfa/cfa_r50_fpn_40e_dota_oc.py)                                      |                                                                           [model](https://download.openmmlab.com/mmrotate/v0.1.0/cfa/cfa_r50_fpn_40e_dota_oc/cfa_r50_fpn_40e_dota_oc-2f387232.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/cfa/cfa_r50_fpn_40e_dota_oc/cfa_r50_fpn_40e_dota_oc_20220209_171237.log.json)                                                                           |
|  ResNet50 (1024,1024,200)  | 73.91 | le135  |  1x  |   3.14    |    15.5    |   -   |  2   |                               [s2anet_r50_fpn_1x_dota_le135](../../configs/s2anet/s2anet_r50_fpn_1x_dota_le135.py)                                |                                                              [model](https://download.openmmlab.com/mmrotate/v0.1.0/s2anet/s2anet_r50_fpn_1x_dota_le135/s2anet_r50_fpn_1x_dota_le135-5dfcf396.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/s2anet/s2anet_r50_fpn_1x_dota_le135/s2anet_r50_fpn_1x_dota_le135_20220124_163529.log.json)                                                              |
|  ResNet50 (1024,1024,200)  | 74.19 | le135  |  1x  |   2.17    |    17.4    |   -   |  2   |                              [s2anet_r50_fpn_fp16_1x_dota_le135](../../configs/s2anet_r50_fpn_fp16_1x_dota_le135.py)                              |                                                    [model](https://download.openmmlab.com/mmrotate/v0.1.0/s2anet/s2anet_r50_fpn_fp16_1x_dota_le135/s2anet_r50_fpn_fp16_1x_dota_le135-5cac515c.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/s2anet/s2anet_r50_fpn_fp16_1x_dota_le135/s2anet_r50_fpn_fp16_1x_dota_le135_20220303_194910.log.json)                                                    |
|  ResNet50 (1024,1024,200)  | 75.63 |  le90  |  1x  |   7.37    |    21.2    |   -   |  2   |                        [oriented_rcnn_r50_fpn_fp16_1x_dota_le90](../../configs/oriented_rcnn_r50_fpn_fp16_1x_dota_le90.py)                        |                                 [model](https://download.openmmlab.com/mmrotate/v0.1.0/oriented_rcnn/oriented_rcnn_r50_fpn_fp16_1x_dota_le90/oriented_rcnn_r50_fpn_fp16_1x_dota_le90-57c88621.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/oriented_rcnn/oriented_rcnn_r50_fpn_fp16_1x_dota_le90/oriented_rcnn_r50_fpn_fp16_1x_dota_le90_20220303_195049.log.json)                                 |
|  ResNet50 (1024,1024,200)  | 75.69 |  le90  |  1x  |   8.46    |    16.2    |   -   |  2   |                      [oriented_rcnn_r50_fpn_1x_dota_le90](../../configs/oriented_rcnn/oriented_rcnn_r50_fpn_1x_dota_le90.py)                      |                                           [model](https://download.openmmlab.com/mmrotate/v0.1.0/oriented_rcnn/oriented_rcnn_r50_fpn_1x_dota_le90/oriented_rcnn_r50_fpn_1x_dota_le90-6d2b2ce0.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/oriented_rcnn/oriented_rcnn_r50_fpn_1x_dota_le90/oriented_rcnn_r50_fpn_1x_dota_le90_20220127_100150.log.json)                                           |
|  ResNet50 (1024,1024,200)  | 75.75 |  le90  |  1x  |   7.56    |    19.3    |   -   |  2   |                            [roi_trans_r50_fpn_fp16_1x_dota_le90](../../configs/roi_trans_r50_fpn_fp16_1x_dota_le90.py)                            |                                             [model](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_r50_fpn_fp16_1x_dota_le90/roi_trans_r50_fpn_fp16_1x_dota_le90-62eb88b1.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_r50_fpn_fp16_1x_dota_le90/roi_trans_r50_fpn_fp16_1x_dota_le90_20220303_193513.log.json)                                             |
| ReResNet50 (1024,1024,200) | 75.99 |  le90  |  1x  |   7.71    |    13.3    |   -   |  2   |                             [redet_re50_refpn_fp16_1x_dota_le90](../../configs/redet_re50_refpn_fp16_1x_dota_le90.py)                             |                                                   [model](https://download.openmmlab.com/mmrotate/v0.1.0/redet/redet_re50_refpn_fp16_1x_dota_le90/redet_re50_refpn_fp16_1x_dota_le90-1e34da2d.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/redet/redet_re50_refpn_fp16_1x_dota_le90/redet_re50_refpn_fp16_1x_dota_le90_20220303_194725.log.json)                                                   |
|  ResNet50 (1024,1024,200)  | 76.08 |  le90  |  1x  |   8.67    |    14.4    |   -   |  2   |                            [roi_trans_r50_fpn_1x_dota_le90](../../configs/roi_trans/roi_trans_r50_fpn_1x_dota_le90.py)                            |                                                       [model](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_r50_fpn_1x_dota_le90/roi_trans_r50_fpn_1x_dota_le90-d1f0b77a.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_r50_fpn_1x_dota_le90/roi_trans_r50_fpn_1x_dota_le90_20220130_132727.log.json)                                                       |
|  ResNet50 (1024,1024,200)  | 76.50 |  le90  |  1x  |           |    17.5    | MS+RR |  2   |      [rotated_retinanet_obb_r50_fpn_1x_dota_ms_rr_le90](../../configs/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_ms_rr_le90.py)      |           [model](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_ms_rr_le90/rotated_retinanet_obb_r50_fpn_1x_dota_ms_rr_le90-1da1ec9c.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/rotated_retinanet/rotated_retinanet_obb_r50_fpn_1x_dota_ms_rr_le90/rotated_retinanet_obb_r50_fpn_1x_dota_ms_rr_le90_20220210_114843.log.json)           |
| ReResNet50 (1024,1024,200) | 76.68 |  le90  |  1x  |   9.32    |    10.9    |   -   |  2   |                               [redet_re50_refpn_1x_dota_le90](../../configs/redet/redet_re50_refpn_1x_dota_le90.py)                               |                                                                 [model](https://download.openmmlab.com/mmrotate/v0.1.0/redet/redet_re50_fpn_1x_dota_le90/redet_re50_fpn_1x_dota_le90-724ab2da.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/redet/redet_re50_fpn_1x_dota_le90/redet_re50_fpn_1x_dota_le90_20220130_132751.log.json)                                                                 |
| Swin-tiny (1024,1024,200)  | 77.51 |  le90  |  1x  |           |    10.9    |   -   |  2   |                      [roi_trans_swin_tiny_fpn_1x_dota_le90](../../configs/roi_trans/roi_trans_swin_tiny_fpn_1x_dota_le90.py)                      |                                           [model](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_swin_tiny_fpn_1x_dota_le90/roi_trans_swin_tiny_fpn_1x_dota_le90-ddeee9ae.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_swin_tiny_fpn_1x_dota_le90/roi_trans_swin_tiny_fpn_1x_dota_le90_20220131_083622.log.json)                                           |
|  ResNet50 (1024,1024,200)  | 79.66 |  le90  |  1x  |           |    14.4    | MS+RR |  2   |                         [roi_trans_r50_fpn_1x_dota_ms_le90](../../configs/roi_trans/roi_trans_r50_fpn_1x_dota_ms_le90.py)                         |                                           [model](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_r50_fpn_1x_dota_ms_rr_le90/roi_trans_r50_fpn_1x_dota_ms_rr_le90-fa99496f.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/roi_trans/roi_trans_r50_fpn_1x_dota_ms_rr_le90/roi_trans_r50_fpn_1x_dota_ms_rr_le90_20220205_171729.log.json)                                           |
| ReResNet50 (1024,1024,200) | 79.87 |  le90  |  1x  |           |    10.9    | MS+RR |  2   |                         [redet_re50_refpn_1x_dota_ms_rr_le90](../../configs/redet/redet_re50_refpn_1x_dota_ms_rr_le90.py)                         |                                                     [model](https://download.openmmlab.com/mmrotate/v0.1.0/redet/redet_re50_fpn_1x_dota_ms_rr_le90/redet_re50_fpn_1x_dota_ms_rr_le90-fc9217b5.pth) &#124; [log](https://download.openmmlab.com/mmrotate/v0.1.0/redet/redet_re50_fpn_1x_dota_ms_rr_le90/redet_re50_fpn_1x_dota_ms_rr_le90_20220206_105343.log.json)                                                     |

- `MS` 表示多尺度图像增强。
- `RR` 表示随机旋转增强。

上述模型都是使用 1 * 1080ti/2080ti 训练得到的，并且在 1 * 2080ti 上进行推理测试。
